s        N   / D
  
                                     Ki7001      <KEITHLEY 7001 Switch system>                   ViInt16     ViInt32    ViReal64      ViRsrc     	 	ViBoolean     	 	ViSession      ViStatus       ViChar[]      ViChar      ViString     	  ViInt16[]     	  ViInt32[]     
  	ViReal64[]      	 
ViBoolean[]      This instrument module provides programming support for the <KEITHLEY 7001/7002 Scanners>.  The module is divided into the following functions:

Functions/Classes:

(1) Initialize:
This function initializes the instrument and sets it to a default configuration.

(2) Miscellaneous Functions: (Class)
This class provide a set of functions used to setup global parameters for the instrument.

(3) Route (Class)
This class provide the basic functions to close, open relays and to define scan lists.

(4) Instrument Registers (Class)
This class provide functions to read and write the instrument registers. Also it provide a globalized SRQ programming function that manage all the details.

(5) Triggers (Class)
This class provide all the functions necessary to setup the three different layers used for the triggering model of the scanners.

(6) Utility Functions: (Class)
This class of functions provides lower level functions to communicate with the instrument, and change instrument parameters.

(7) Close:
This function takes the instrument offline.

This driver provide some definitions and helpers

a) Lists of constants defined in Ki7001.h

#define KI7001_DEFAULT_DISPLAY      0
#define KI7001_USER_DISPLAY         1

#define KI7001_INTERNAL_TTL         1
#define KI7001_SLOT1_TTL            2
#define KI7001_SLOT2_TTL            3

#define RST_SETUP                   -2
#define PRES_SETUP                  -1
#define USER0_SETUP                 0
#define USER1_SETUP                 1
#define USER2_SETUP                 2
#define USER3_SETUP                 3
#define USER4_SETUP                 4
#define USER5_SETUP                 5
#define USER6_SETUP                 6
#define USER7_SETUP                 7
#define USER8_SETUP                 8
#define USER9_SETUP                 9

#define KI7001_REG_SRE              0
#define KI7001_REG_ESE              1
#define KI7001_REG_OPER_ENAB        2
#define KI7001_REG_OPER_TRANS       3
#define KI7001_REG_ARM_ENAB         4
#define KI7001_REG_ARM_TRANS        5
#define KI7001_REG_SEQ_ENAB         6
#define KI7001_REG_SEQ_TRANS        7
#define KI7001_REG_QUES_ENAB        8
#define KI7001_REG_QUES_TRANS       9
#define KI7001_REG_TRIG_ENAB        10
#define KI7001_REG_TRIG_TRANS       11
#define KI7001_REG_STB              12
#define KI7001_REG_ESE_EVENT        13
#define KI7001_REG_OPER_EVENT       14
#define KI7001_REG_OPER_COND        15
#define KI7001_REG_ARM_EVENT        16
#define KI7001_REG_ARM_COND         17
#define KI7001_REG_SEQ_EVENT        18
#define KI7001_REG_SEQ_COND         19
#define KI7001_REG_QUES_EVENT       20
#define KI7001_REG_QUES_COND        21
#define KI7001_REG_TRIG_EVENT       22
#define KI7001_REG_TRIG_COND        23

#define KI7001_CLEAR_SRQ_CONDITION     0x0000    //Clear all SRQ condition
#define KI7001_SRQ_ON_IN_TRIG_LAYER    0x0001
#define KI7001_SRQ_ON_IN_ARM_LAYER1    0x0002
#define KI7001_SRQ_ON_IN_ARM_LAYER2    0x0004
#define KI7001_SRQ_ON_SETTLING         0x0008
#define KI7001_SRQ_ON_IN_IDLE          0x0010
#define KI7001_SRQ_ON_ERROR_AVAIL      0x0020
#define KI7001_SRQ_ON_MESSAGE_AVAIL    0x0040
#define KI7001_SRQ_ON_OP_COMPLETED     0x0080
#define KI7001_SRQ_ON_REQCTRL          0x0100
#define KI7001_SRQ_ON_DEVICE_ERROR     0x0200
#define KI7001_SRQ_ON_EXEC_ERROR       0x0400
#define KI7001_SRQ_ON_CMD_ERROR        0x0800
#define KI7001_SRQ_ON_USER_REQUEST     0x1000

#define KI7001_TRIG_ON_IMMEDIATE        0
#define KI7001_TRIG_ON_MANUAL           1
#define KI7001_TRIG_ON_BUS              2
#define KI7001_TRIG_ON_EXTERNAL         3
#define KI7001_TRIG_ON_TLINK            4
#define KI7001_TRIG_ON_TIMER            5

#define KI7001_ACCEPTOR                 0
#define KI7001_SOURCE                   1

#define KI7001_TLINK_LINE1              1
#define KI7001_TLINK_LINE2              2
#define KI7001_TLINK_LINE3              3
#define KI7001_TLINK_LINE4              4
#define KI7001_TLINK_LINE5              5
#define KI7001_TLINK_LINE6              6

#define KI7001_ARM_LAYER                0
#define KI7001_SCAN_LAYER               1
#define KI7001_CHAN_LAYER               2

#define KI7001_CARD_7052                7052
#define KI7001_CARD_7053                7053
#define KI7001_CARD_7054                7054
#define KI7001_CARD_7056                7056
#define KI7001_CARD_7057                7057
#define KI7001_CARD_7058                7058
#define KI7001_CARD_7059                7059
#define KI7001_CARD_7061                7061
#define KI7001_CARD_7062                7062
#define KI7001_CARD_7063                7063
#define KI7001_CARD_7064                7064
#define KI7001_CARD_7065                7065
#define KI7001_CARD_7066                7066
#define KI7001_CARD_7067                7067
#define KI7001_CARD_7152                7152
#define KI7001_CARD_7153                7153
#define KI7001_CARD_7154                7154
#define KI7001_CARD_7156                7156
#define KI7001_CARD_7158                7158
#define KI7001_CARD_7164                7164
#define KI7001_CARD_7166                7166
#define KI7001_CARD_7168                7168
#define KI7001_CARD_7169                7169
#define KI7001_CARD_7402                7402
#define KI7001_CARD_9990                9990
#define KI7001_CARD_9991                9991

#define KI7001_1_POLE                   1
#define KI7001_2_POLES                  2
#define KI7001_4_POLES                  4

#define KI7001_ENABLE                   1
#define KI7001_DISBLE                   0

b) Helpers

char *Ki7001_MAKESCANCHAN (char *buffer, int slot, int row, int column);
char *Ki7001_MAKEMUXCHAN (char *buffer, int slot, int channel);
char *Ki7001_MAKEMEMCHAN (char *buffer, int memory);
char *Ki7001_MAKECONTIGUOUSLIST (char *buffer, char *start, char *stop);
char *Ki7001_ADDTOLIST (char *buffer, char *actual, char *new);

    w    This class provide several functions used to setup global parameters fr the instrument. You can control the front panels, the digital IO lines, the default power on setup.

It also define functions used to control global behavior for the scanner and the scanning cards. By example, you can control channel pairing, Single channel Mode, Break Before Make operations, etc....         This class define the necessary functions used to control relays. You can close and/or opens relays using lists of relays. You can also define a scan list to be executed according to the triggering model defined by the Trigger class functions.         This class gives you the capability to directly control the registers of the instrument. It also provide a function to ease the use of the SRQ generation.
         This class provide functions to control the triggering model of the instrument. This model is based on three different layer of triggers. Each layer has a specific function to set it up. There are also function to control the execution of the model.    R    This class of functions provides lower level functions to communicate with the instrument, and change instrument parameters.

Functions:

(1) Reset:
This function resets the instrument to its default state.

(2) Self-Test:
This function runs the instrument self test and returns the test code.

(3) Error Query:
This function reads an error code from the instrument error queue.

(4) Error Message:
This function takes the Status Code and returns it as a user readable string.
 
(5) Revision Query:
This function returns the revision numbers of the instrument driver and instrument firmware.
    3    This function performs the following initialization actions:

- Opens a session to the Default Resource Manager resource and a session to the specified device using the interface and address specified in the Resource_Name control.

- Performs an identification query on the Instrument.

- Resets the instrument to a known state.

- Sends initialization commands to the instrument that set any necessary programmatic variables such as Headers Off, Short Command form, and Data Transfer Binary to the state necessary for the operation of the instrument driver.

- Returns an Instrument Handle which is used to differentiate between different sessions of this instrument driver.

- Each time this function is invoked a Unique Session is opened.  It is possible to have more than one session open for the same resource.

    q    This control specifies the interface and address of the device that is to be initialized (Instrument Descriptor). The exact grammar to be used in this control is shown in the note below. 

Default Value:  "GPIB::1"

Notes:

(1) Based on the Instrument Descriptor, this operation establishes a communication session with a device.  The grammar for the Instrument Descriptor is shown below.  Optional parameters are shown in square brackets ([]).

Interface   Grammar
------------------------------------------------------
GPIB        GPIB[board]::primary address[::secondary address]
            [::INSTR]
            
The GPIB keyword is used with GPIB instruments.

The default value for optional parameters are shown below.

Optional Parameter          Default Value
-----------------------------------------
board                       0
secondary address           none - 31
    2    This control specifies if the instrument is to be reset to its power-on settings during the initialization procedure.

Valid Range:
VI_OFF (0) - Don't Reset
VI_ON  (1) - Reset Device (Default Value)

Notes:

(1) If you do not want the instrument reset. Set this control to "Don't Reset" while initializing the instrument.

/**** DELETE THIS NOTE AND THE STATUS CODE IF SUPPORTED *****/
(2) If this instrument does not support a Reset, and this control is set to "Reset Device" then this function should return the Warning Code 0x3FFC0102 - VI_WARN_NSUP_RESET.
    7    This control returns an Instrument Handle that is used in all subsequent function calls to differentiate between different sessions of this instrument driver.

Notes:

(1) Each time this function is invoked a Unique Session is opened.  It is possible to have more than one session open for the same resource.
    
    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFC0101  ID Query not supported - VI_WARN_NSUP_ID_QUERY   
3FFC0102  Reset not supported - VI_WARN_NSUP_RESET      
3FFC0103  Self Test not supported - VI_WARN_NSUP_SELF_TEST  
3FFC0104  Error Query not supported - VI_WARN_NSUP_ERROR_QUERY
3FFC0105  Revision Query not supported - VI_WARN_NSUP_REV_QUERY  
3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0001  Parameter 1 out of range. (String not range checked)
BFFC0002  Parameter 2 (ID Query) out of range.
BFFC0003  Parameter 3 (Reset Device) out of range.
BFFC0004  Parameter 4 out of range.
BFFC0005  Parameter 5 out of range.
BFFC0006  Parameter 6 out of range.
BFFC0007  Parameter 7 out of range.
BFFC0008  Parameter 8 out of range.
BFFC0011  Instrument returned invalid response to ID Query

BFFC0800  Error Opening File      VI_ERROR_INSTR_FILE_OPEN
BFFC0801  Error Writing to File   VI_ERROR_INSTR_FILE_WRITE
BFFC0803  Invalid Response VI_ERROR_INSTR_INTERPRETING_RESPONSE

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.

Notes:

(1) Parameter Error Codes for parameters 1 through 8 are defined in the vpptype.h header file the range is BFFC0001 - BFFC0008; for parameter errors greater than 8, and other instrument specific error codes, use an error code in the range of BFFC0900 to BFFC0FFF.  This is equivalent to using (VI_INSTR_ERROR_OFFSET + n); where n represents each instrument specific error number.  Valid ranges for n are 0 to 6FF.  (All values are given in Hexadecimal Notation)

(2) Delete all unused status codes from the Status Control of each function panel when you are finished development of your instrument driver, for example in this control the status codes for parameters 1, 3-8, and the codes for Error Opening and Writing to File should be deleted.  Those status codes are provided here as a convenience for during driver development.  

(3) Delete these three (3) notes when you are finished with your driver development.    ",          Resource Name                     %          Reset Device                      ' ]    }    Instrument Handle                 ) ]      Status                             
"GPIB::1"  & Reset Device VI_ON Don't Reset VI_OFF    	           	              This function gives you the control of the KEITHLEY 7001/7002 scanner front panel LED display. You can select the window you want to use. Then in the selected window, you can control if the display will use the default display or your user message.

/* Function prototype */

ViStatus Ki7001_FrontPanel(
    ViSession instrumentHandle, 
    ViInt16 window,
    ViInt16 displayMode, 
    ViChar userMessage[]);
    
    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFC0101  ID Query not supported - VI_WARN_NSUP_ID_QUERY   
3FFC0102  Reset not supported - VI_WARN_NSUP_RESET      
3FFC0103  Self Test not supported - VI_WARN_NSUP_SELF_TEST  
3FFC0104  Error Query not supported - VI_WARN_NSUP_ERROR_QUERY
3FFC0105  Revision Query not supported - VI_WARN_NSUP_REV_QUERY  
3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0001  Parameter 1 out of range. (String not range checked)
BFFC0002  Parameter 2 (ID Query) out of range.
BFFC0003  Parameter 3 (Reset Device) out of range.
BFFC0004  Parameter 4 out of range.
BFFC0005  Parameter 5 out of range.
BFFC0006  Parameter 6 out of range.
BFFC0007  Parameter 7 out of range.
BFFC0008  Parameter 8 out of range.
BFFC0011  Instrument returned invalid response to ID Query

BFFC0800  Error Opening File      VI_ERROR_INSTR_FILE_OPEN
BFFC0801  Error Writing to File   VI_ERROR_INSTR_FILE_WRITE
BFFC0803  Invalid Response VI_ERROR_INSTR_INTERPRETING_RESPONSE

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.

Notes:

(1) Parameter Error Codes for parameters 1 through 8 are defined in the vpptype.h header file the range is BFFC0001 - BFFC0008; for parameter errors greater than 8, and other instrument specific error codes, use an error code in the range of BFFC0900 to BFFC0FFF.  This is equivalent to using (VI_INSTR_ERROR_OFFSET + n); where n represents each instrument specific error number.  Valid ranges for n are 0 to 6FF.  (All values are given in Hexadecimal Notation)

(2) Delete all unused status codes from the Status Control of each function panel when you are finished development of your instrument driver, for example in this control the status codes for parameters 1, 3-8, and the codes for Error Opening and Writing to File should be deleted.  Those status codes are provided here as a convenience for during driver development.  

(3) Delete these three (3) notes when you are finished with your driver development.         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None   #2       Display Mode                     d   ,    User Message                      6 d      Status                           #        Window                            Ad #         Instrument Handle                             Default 0 User 1    Keithley 7001    	                      Top 1 Bottom 2            This function allows you to control the digital output lines of the instrument.

/* Function prototype */

ViStatus Ki7001_TTLOutput(
    ViSession instrumentHandle, 
    ViInt16 value);
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    
    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFC0101  ID Query not supported - VI_WARN_NSUP_ID_QUERY   
3FFC0102  Reset not supported - VI_WARN_NSUP_RESET      
3FFC0103  Self Test not supported - VI_WARN_NSUP_SELF_TEST  
3FFC0104  Error Query not supported - VI_WARN_NSUP_ERROR_QUERY
3FFC0105  Revision Query not supported - VI_WARN_NSUP_REV_QUERY  
3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0001  Parameter 1 out of range. (String not range checked)
BFFC0002  Parameter 2 (ID Query) out of range.
BFFC0003  Parameter 3 (Reset Device) out of range.
BFFC0004  Parameter 4 out of range.
BFFC0005  Parameter 5 out of range.
BFFC0006  Parameter 6 out of range.
BFFC0007  Parameter 7 out of range.
BFFC0008  Parameter 8 out of range.
BFFC0011  Instrument returned invalid response to ID Query

BFFC0800  Error Opening File      VI_ERROR_INSTR_FILE_OPEN
BFFC0801  Error Writing to File   VI_ERROR_INSTR_FILE_WRITE
BFFC0803  Invalid Response VI_ERROR_INSTR_INTERPRETING_RESPONSE

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.

Notes:

(1) Parameter Error Codes for parameters 1 through 8 are defined in the vpptype.h header file the range is BFFC0001 - BFFC0008; for parameter errors greater than 8, and other instrument specific error codes, use an error code in the range of BFFC0900 to BFFC0FFF.  This is equivalent to using (VI_INSTR_ERROR_OFFSET + n); where n represents each instrument specific error number.  Valid ranges for n are 0 to 6FF.  (All values are given in Hexadecimal Notation)

(2) Delete all unused status codes from the Status Control of each function panel when you are finished development of your instrument driver, for example in this control the status codes for parameters 1, 3-8, and the codes for Error Opening and Writing to File should be deleted.  Those status codes are provided here as a convenience for during driver development.  

(3) Delete these three (3) notes when you are finished with your driver development.    D0          Instrument Handle                 D       Status                                   Value                                  	                                    This function is used to teach to the instrument which type of old KEITHLEY scanner card is installed in one of its slots. This function is not to be called with the newer cards from KEITHLEY, because the scanner is able to detect the type of board by itself. It must only be used for older cards compatible with 705 or 706 KEITHLEY scanners.

Two special entries are provided for virtual cards. the model 9990 is a virtual multiplexer card 1X40, the model 9991 is a virtual scanner card 4X10. You can use these virtual cards during design of your software.

/* Function prototype */

ViStatus Ki7001_DefineScannerCard(
    ViSession instrumentHandle, 
    ViInt16 slot,
    ViInt16 type);
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    
    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFC0101  ID Query not supported - VI_WARN_NSUP_ID_QUERY   
3FFC0102  Reset not supported - VI_WARN_NSUP_RESET      
3FFC0103  Self Test not supported - VI_WARN_NSUP_SELF_TEST  
3FFC0104  Error Query not supported - VI_WARN_NSUP_ERROR_QUERY
3FFC0105  Revision Query not supported - VI_WARN_NSUP_REV_QUERY  
3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0001  Parameter 1 out of range. (String not range checked)
BFFC0002  Parameter 2 (ID Query) out of range.
BFFC0003  Parameter 3 (Reset Device) out of range.
BFFC0004  Parameter 4 out of range.
BFFC0005  Parameter 5 out of range.
BFFC0006  Parameter 6 out of range.
BFFC0007  Parameter 7 out of range.
BFFC0008  Parameter 8 out of range.
BFFC0011  Instrument returned invalid response to ID Query

BFFC0800  Error Opening File      VI_ERROR_INSTR_FILE_OPEN
BFFC0801  Error Writing to File   VI_ERROR_INSTR_FILE_WRITE
BFFC0803  Invalid Response VI_ERROR_INSTR_INTERPRETING_RESPONSE

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.

Notes:

(1) Parameter Error Codes for parameters 1 through 8 are defined in the vpptype.h header file the range is BFFC0001 - BFFC0008; for parameter errors greater than 8, and other instrument specific error codes, use an error code in the range of BFFC0900 to BFFC0FFF.  This is equivalent to using (VI_INSTR_ERROR_OFFSET + n); where n represents each instrument specific error number.  Valid ranges for n are 0 to 6FF.  (All values are given in Hexadecimal Notation)

(2) Delete all unused status codes from the Status Control of each function panel when you are finished development of your instrument driver, for example in this control the status codes for parameters 1, 3-8, and the codes for Error Opening and Writing to File should be deleted.  Those status codes are provided here as a convenience for during driver development.  

(3) Delete these three (3) notes when you are finished with your driver development.    S  
        Instrument Handle                 S       Status                                   Slot                             X       Type                                   	              
                          7052 7052 7053 7053 7054 7054 7056 7056 7057 7057 7058 7058 7059 7059 7061 7061 7062 7062 7063 7063 7064 7064 7065 7065 7066 7066 7067 7067 7152 7152 7153 7153 7154 7154 7156 7156 7158 7158 7164 7164 7166 7166 7168 7168 7169 7169 7402 7402 9990 9990 9991 9991        This function queries the type of card installed in a specfic slot of the instrument. It return the card model number.

/* Function prototype */

ViStatus Ki7001_QueryScannerCard(
    ViSession instrumentHandle, 
    ViInt16 slot,
    ViInt16 *type);
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    
    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFC0101  ID Query not supported - VI_WARN_NSUP_ID_QUERY   
3FFC0102  Reset not supported - VI_WARN_NSUP_RESET      
3FFC0103  Self Test not supported - VI_WARN_NSUP_SELF_TEST  
3FFC0104  Error Query not supported - VI_WARN_NSUP_ERROR_QUERY
3FFC0105  Revision Query not supported - VI_WARN_NSUP_REV_QUERY  
3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0001  Parameter 1 out of range. (String not range checked)
BFFC0002  Parameter 2 (ID Query) out of range.
BFFC0003  Parameter 3 (Reset Device) out of range.
BFFC0004  Parameter 4 out of range.
BFFC0005  Parameter 5 out of range.
BFFC0006  Parameter 6 out of range.
BFFC0007  Parameter 7 out of range.
BFFC0008  Parameter 8 out of range.
BFFC0011  Instrument returned invalid response to ID Query

BFFC0800  Error Opening File      VI_ERROR_INSTR_FILE_OPEN
BFFC0801  Error Writing to File   VI_ERROR_INSTR_FILE_WRITE
BFFC0803  Invalid Response VI_ERROR_INSTR_INTERPRETING_RESPONSE

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.

Notes:

(1) Parameter Error Codes for parameters 1 through 8 are defined in the vpptype.h header file the range is BFFC0001 - BFFC0008; for parameter errors greater than 8, and other instrument specific error codes, use an error code in the range of BFFC0900 to BFFC0FFF.  This is equivalent to using (VI_INSTR_ERROR_OFFSET + n); where n represents each instrument specific error number.  Valid ranges for n are 0 to 6FF.  (All values are given in Hexadecimal Notation)

(2) Delete all unused status codes from the Status Control of each function panel when you are finished development of your instrument driver, for example in this control the status codes for parameters 1, 3-8, and the codes for Error Opening and Writing to File should be deleted.  Those status codes are provided here as a convenience for during driver development.  

(3) Delete these three (3) notes when you are finished with your driver development.    a  
        Instrument Handle                        Slot                              b"       Status                                   Type                                      
                 	           	               This function allows you to control the number of poles used in switching. This function is used only for cards that can have multiple type of scanning. By example, the 7056 card can be used as a 10 channels 2 poles multiplexer card, or as a 20 channels 1 pole multiplexer card. You should use this function only with cards that support multiple poles configurations.

/* Function prototype */

ViStatus Ki7001_SetPoles(
    ViSession instrumentHandle, 
    ViInt16 slot, 
    ViInt16 poles);

         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    
    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFC0101  ID Query not supported - VI_WARN_NSUP_ID_QUERY   
3FFC0102  Reset not supported - VI_WARN_NSUP_RESET      
3FFC0103  Self Test not supported - VI_WARN_NSUP_SELF_TEST  
3FFC0104  Error Query not supported - VI_WARN_NSUP_ERROR_QUERY
3FFC0105  Revision Query not supported - VI_WARN_NSUP_REV_QUERY  
3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0001  Parameter 1 out of range. (String not range checked)
BFFC0002  Parameter 2 (ID Query) out of range.
BFFC0003  Parameter 3 (Reset Device) out of range.
BFFC0004  Parameter 4 out of range.
BFFC0005  Parameter 5 out of range.
BFFC0006  Parameter 6 out of range.
BFFC0007  Parameter 7 out of range.
BFFC0008  Parameter 8 out of range.
BFFC0011  Instrument returned invalid response to ID Query

BFFC0800  Error Opening File      VI_ERROR_INSTR_FILE_OPEN
BFFC0801  Error Writing to File   VI_ERROR_INSTR_FILE_WRITE
BFFC0803  Invalid Response VI_ERROR_INSTR_INTERPRETING_RESPONSE

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.

Notes:

(1) Parameter Error Codes for parameters 1 through 8 are defined in the vpptype.h header file the range is BFFC0001 - BFFC0008; for parameter errors greater than 8, and other instrument specific error codes, use an error code in the range of BFFC0900 to BFFC0FFF.  This is equivalent to using (VI_INSTR_ERROR_OFFSET + n); where n represents each instrument specific error number.  Valid ranges for n are 0 to 6FF.  (All values are given in Hexadecimal Notation)

(2) Delete all unused status codes from the Status Control of each function panel when you are finished development of your instrument driver, for example in this control the status codes for parameters 1, 3-8, and the codes for Error Opening and Writing to File should be deleted.  Those status codes are provided here as a convenience for during driver development.  

(3) Delete these three (3) notes when you are finished with your driver development.    o          Instrument Handle                        Slot                              p       Status                           \       Poles                                     
                 	                      1 pole 1 2 poles 2 4 poles 4        This function return the number of poles used by the card installed in the selected slot.

/* Function prototype */

ViStatus Ki7001_QueryPoles(
    ViSession instrumentHandle, 
    ViInt16 slot,
    ViInt16 *poles);
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    
    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFC0101  ID Query not supported - VI_WARN_NSUP_ID_QUERY   
3FFC0102  Reset not supported - VI_WARN_NSUP_RESET      
3FFC0103  Self Test not supported - VI_WARN_NSUP_SELF_TEST  
3FFC0104  Error Query not supported - VI_WARN_NSUP_ERROR_QUERY
3FFC0105  Revision Query not supported - VI_WARN_NSUP_REV_QUERY  
3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0001  Parameter 1 out of range. (String not range checked)
BFFC0002  Parameter 2 (ID Query) out of range.
BFFC0003  Parameter 3 (Reset Device) out of range.
BFFC0004  Parameter 4 out of range.
BFFC0005  Parameter 5 out of range.
BFFC0006  Parameter 6 out of range.
BFFC0007  Parameter 7 out of range.
BFFC0008  Parameter 8 out of range.
BFFC0011  Instrument returned invalid response to ID Query

BFFC0800  Error Opening File      VI_ERROR_INSTR_FILE_OPEN
BFFC0801  Error Writing to File   VI_ERROR_INSTR_FILE_WRITE
BFFC0803  Invalid Response VI_ERROR_INSTR_INTERPRETING_RESPONSE

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.

Notes:

(1) Parameter Error Codes for parameters 1 through 8 are defined in the vpptype.h header file the range is BFFC0001 - BFFC0008; for parameter errors greater than 8, and other instrument specific error codes, use an error code in the range of BFFC0900 to BFFC0FFF.  This is equivalent to using (VI_INSTR_ERROR_OFFSET + n); where n represents each instrument specific error number.  Valid ranges for n are 0 to 6FF.  (All values are given in Hexadecimal Notation)

(2) Delete all unused status codes from the Status Control of each function panel when you are finished development of your instrument driver, for example in this control the status codes for parameters 1, 3-8, and the codes for Error Opening and Writing to File should be deleted.  Those status codes are provided here as a convenience for during driver development.  

(3) Delete these three (3) notes when you are finished with your driver development.    }J          Instrument Handle                        Slot                              }       Status                                   Poles                                     
                 	           	           {    This function control the settling time of the relays. This delay is used by the scanner after it close a relay and before to send any other trigger to any external instrument or device. It allows you to ensure a good signal reliability.

/* Function prototype */

ViStatus Ki7001_SetSettlingTime(
    ViSession instrumentHandle, 
    ViInt16 slot,
    ViReal64 settlingTime);
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    
    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFC0101  ID Query not supported - VI_WARN_NSUP_ID_QUERY   
3FFC0102  Reset not supported - VI_WARN_NSUP_RESET      
3FFC0103  Self Test not supported - VI_WARN_NSUP_SELF_TEST  
3FFC0104  Error Query not supported - VI_WARN_NSUP_ERROR_QUERY
3FFC0105  Revision Query not supported - VI_WARN_NSUP_REV_QUERY  
3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0001  Parameter 1 out of range. (String not range checked)
BFFC0002  Parameter 2 (ID Query) out of range.
BFFC0003  Parameter 3 (Reset Device) out of range.
BFFC0004  Parameter 4 out of range.
BFFC0005  Parameter 5 out of range.
BFFC0006  Parameter 6 out of range.
BFFC0007  Parameter 7 out of range.
BFFC0008  Parameter 8 out of range.
BFFC0011  Instrument returned invalid response to ID Query

BFFC0800  Error Opening File      VI_ERROR_INSTR_FILE_OPEN
BFFC0801  Error Writing to File   VI_ERROR_INSTR_FILE_WRITE
BFFC0803  Invalid Response VI_ERROR_INSTR_INTERPRETING_RESPONSE

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.

Notes:

(1) Parameter Error Codes for parameters 1 through 8 are defined in the vpptype.h header file the range is BFFC0001 - BFFC0008; for parameter errors greater than 8, and other instrument specific error codes, use an error code in the range of BFFC0900 to BFFC0FFF.  This is equivalent to using (VI_INSTR_ERROR_OFFSET + n); where n represents each instrument specific error number.  Valid ranges for n are 0 to 6FF.  (All values are given in Hexadecimal Notation)

(2) Delete all unused status codes from the Status Control of each function panel when you are finished development of your instrument driver, for example in this control the status codes for parameters 1, 3-8, and the codes for Error Opening and Writing to File should be deleted.  Those status codes are provided here as a convenience for during driver development.  

(3) Delete these three (3) notes when you are finished with your driver development.    3 $         Instrument Handle                $        Slot                               $      Status                           $        Settling Time                             
                 	           0        This function return the settling time used for the card installed in the selected slot.

/* Function Prototype */

ViStatus Ki7001_QuerySettlingTime(
     ViSession instrumentHandle, 
     ViInt16 slot,
     ViReal64 *settlingTime);
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    
    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFC0101  ID Query not supported - VI_WARN_NSUP_ID_QUERY   
3FFC0102  Reset not supported - VI_WARN_NSUP_RESET      
3FFC0103  Self Test not supported - VI_WARN_NSUP_SELF_TEST  
3FFC0104  Error Query not supported - VI_WARN_NSUP_ERROR_QUERY
3FFC0105  Revision Query not supported - VI_WARN_NSUP_REV_QUERY  
3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0001  Parameter 1 out of range. (String not range checked)
BFFC0002  Parameter 2 (ID Query) out of range.
BFFC0003  Parameter 3 (Reset Device) out of range.
BFFC0004  Parameter 4 out of range.
BFFC0005  Parameter 5 out of range.
BFFC0006  Parameter 6 out of range.
BFFC0007  Parameter 7 out of range.
BFFC0008  Parameter 8 out of range.
BFFC0011  Instrument returned invalid response to ID Query

BFFC0800  Error Opening File      VI_ERROR_INSTR_FILE_OPEN
BFFC0801  Error Writing to File   VI_ERROR_INSTR_FILE_WRITE
BFFC0803  Invalid Response VI_ERROR_INSTR_INTERPRETING_RESPONSE

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.

Notes:

(1) Parameter Error Codes for parameters 1 through 8 are defined in the vpptype.h header file the range is BFFC0001 - BFFC0008; for parameter errors greater than 8, and other instrument specific error codes, use an error code in the range of BFFC0900 to BFFC0FFF.  This is equivalent to using (VI_INSTR_ERROR_OFFSET + n); where n represents each instrument specific error number.  Valid ranges for n are 0 to 6FF.  (All values are given in Hexadecimal Notation)

(2) Delete all unused status codes from the Status Control of each function panel when you are finished development of your instrument driver, for example in this control the status codes for parameters 1, 3-8, and the codes for Error Opening and Writing to File should be deleted.  Those status codes are provided here as a convenience for during driver development.  

(3) Delete these three (3) notes when you are finished with your driver development.     ! 
        Instrument Handle                !        Slot                              % !      Status                           !        Settling Time                             
                 	           	               This function control the use of the Break Before Make feature of the instrument. See the KEITHLEY manual to see details concerning this feature.

/* Function prototype */

ViStatus Ki7001_EnableBBM(
    ViSession instrumentHandle, 
    ViInt16 enable);
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    
    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFC0101  ID Query not supported - VI_WARN_NSUP_ID_QUERY   
3FFC0102  Reset not supported - VI_WARN_NSUP_RESET      
3FFC0103  Self Test not supported - VI_WARN_NSUP_SELF_TEST  
3FFC0104  Error Query not supported - VI_WARN_NSUP_ERROR_QUERY
3FFC0105  Revision Query not supported - VI_WARN_NSUP_REV_QUERY  
3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0001  Parameter 1 out of range. (String not range checked)
BFFC0002  Parameter 2 (ID Query) out of range.
BFFC0003  Parameter 3 (Reset Device) out of range.
BFFC0004  Parameter 4 out of range.
BFFC0005  Parameter 5 out of range.
BFFC0006  Parameter 6 out of range.
BFFC0007  Parameter 7 out of range.
BFFC0008  Parameter 8 out of range.
BFFC0011  Instrument returned invalid response to ID Query

BFFC0800  Error Opening File      VI_ERROR_INSTR_FILE_OPEN
BFFC0801  Error Writing to File   VI_ERROR_INSTR_FILE_WRITE
BFFC0803  Invalid Response VI_ERROR_INSTR_INTERPRETING_RESPONSE

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.

Notes:

(1) Parameter Error Codes for parameters 1 through 8 are defined in the vpptype.h header file the range is BFFC0001 - BFFC0008; for parameter errors greater than 8, and other instrument specific error codes, use an error code in the range of BFFC0900 to BFFC0FFF.  This is equivalent to using (VI_INSTR_ERROR_OFFSET + n); where n represents each instrument specific error number.  Valid ranges for n are 0 to 6FF.  (All values are given in Hexadecimal Notation)

(2) Delete all unused status codes from the Status Control of each function panel when you are finished development of your instrument driver, for example in this control the status codes for parameters 1, 3-8, and the codes for Error Opening and Writing to File should be deleted.  Those status codes are provided here as a convenience for during driver development.  

(3) Delete these three (3) notes when you are finished with your driver development.              Instrument Handle                        Status                                  Enable                                 	                     On 1 Off 0        This function return the actual status of the Break Before Make feature.

/* Function prototype */

ViStatus Ki7001_QueryBBM(
     ViSession instrumentHandle, 
     ViInt16 *BBM);
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    
    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFC0101  ID Query not supported - VI_WARN_NSUP_ID_QUERY   
3FFC0102  Reset not supported - VI_WARN_NSUP_RESET      
3FFC0103  Self Test not supported - VI_WARN_NSUP_SELF_TEST  
3FFC0104  Error Query not supported - VI_WARN_NSUP_ERROR_QUERY
3FFC0105  Revision Query not supported - VI_WARN_NSUP_REV_QUERY  
3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0001  Parameter 1 out of range. (String not range checked)
BFFC0002  Parameter 2 (ID Query) out of range.
BFFC0003  Parameter 3 (Reset Device) out of range.
BFFC0004  Parameter 4 out of range.
BFFC0005  Parameter 5 out of range.
BFFC0006  Parameter 6 out of range.
BFFC0007  Parameter 7 out of range.
BFFC0008  Parameter 8 out of range.
BFFC0011  Instrument returned invalid response to ID Query

BFFC0800  Error Opening File      VI_ERROR_INSTR_FILE_OPEN
BFFC0801  Error Writing to File   VI_ERROR_INSTR_FILE_WRITE
BFFC0803  Invalid Response VI_ERROR_INSTR_INTERPRETING_RESPONSE

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.

Notes:

(1) Parameter Error Codes for parameters 1 through 8 are defined in the vpptype.h header file the range is BFFC0001 - BFFC0008; for parameter errors greater than 8, and other instrument specific error codes, use an error code in the range of BFFC0900 to BFFC0FFF.  This is equivalent to using (VI_INSTR_ERROR_OFFSET + n); where n represents each instrument specific error number.  Valid ranges for n are 0 to 6FF.  (All values are given in Hexadecimal Notation)

(2) Delete all unused status codes from the Status Control of each function panel when you are finished development of your instrument driver, for example in this control the status codes for parameters 1, 3-8, and the codes for Error Opening and Writing to File should be deleted.  Those status codes are provided here as a convenience for during driver development.  

(3) Delete these three (3) notes when you are finished with your driver development.              Instrument Handle                 y       Status                                    BBM                                    	           	               This function controls the status of the Single Channel Feature of the instrument. This feature when enbled do not allows 2 relays to be closed at the same time.

/* Function Prototype */

ViStatus Ki7001_EnableSingleChan(
    ViSession instrumentHandle, 
    ViInt16 enable);
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    
    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFC0101  ID Query not supported - VI_WARN_NSUP_ID_QUERY   
3FFC0102  Reset not supported - VI_WARN_NSUP_RESET      
3FFC0103  Self Test not supported - VI_WARN_NSUP_SELF_TEST  
3FFC0104  Error Query not supported - VI_WARN_NSUP_ERROR_QUERY
3FFC0105  Revision Query not supported - VI_WARN_NSUP_REV_QUERY  
3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0001  Parameter 1 out of range. (String not range checked)
BFFC0002  Parameter 2 (ID Query) out of range.
BFFC0003  Parameter 3 (Reset Device) out of range.
BFFC0004  Parameter 4 out of range.
BFFC0005  Parameter 5 out of range.
BFFC0006  Parameter 6 out of range.
BFFC0007  Parameter 7 out of range.
BFFC0008  Parameter 8 out of range.
BFFC0011  Instrument returned invalid response to ID Query

BFFC0800  Error Opening File      VI_ERROR_INSTR_FILE_OPEN
BFFC0801  Error Writing to File   VI_ERROR_INSTR_FILE_WRITE
BFFC0803  Invalid Response VI_ERROR_INSTR_INTERPRETING_RESPONSE

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.

Notes:

(1) Parameter Error Codes for parameters 1 through 8 are defined in the vpptype.h header file the range is BFFC0001 - BFFC0008; for parameter errors greater than 8, and other instrument specific error codes, use an error code in the range of BFFC0900 to BFFC0FFF.  This is equivalent to using (VI_INSTR_ERROR_OFFSET + n); where n represents each instrument specific error number.  Valid ranges for n are 0 to 6FF.  (All values are given in Hexadecimal Notation)

(2) Delete all unused status codes from the Status Control of each function panel when you are finished development of your instrument driver, for example in this control the status codes for parameters 1, 3-8, and the codes for Error Opening and Writing to File should be deleted.  Those status codes are provided here as a convenience for during driver development.  

(3) Delete these three (3) notes when you are finished with your driver development.      	        Instrument Handle                        Status                                  Enable                                 	                     Yes 1 No 0        This function return the actual status of the Single Channel feature.

/* Function prototype */

ViStatus Ki7001_QuerySingleChan(
    ViSession instrumentHandle, 
    ViInt16 *mode);
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    
    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFC0101  ID Query not supported - VI_WARN_NSUP_ID_QUERY   
3FFC0102  Reset not supported - VI_WARN_NSUP_RESET      
3FFC0103  Self Test not supported - VI_WARN_NSUP_SELF_TEST  
3FFC0104  Error Query not supported - VI_WARN_NSUP_ERROR_QUERY
3FFC0105  Revision Query not supported - VI_WARN_NSUP_REV_QUERY  
3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0001  Parameter 1 out of range. (String not range checked)
BFFC0002  Parameter 2 (ID Query) out of range.
BFFC0003  Parameter 3 (Reset Device) out of range.
BFFC0004  Parameter 4 out of range.
BFFC0005  Parameter 5 out of range.
BFFC0006  Parameter 6 out of range.
BFFC0007  Parameter 7 out of range.
BFFC0008  Parameter 8 out of range.
BFFC0011  Instrument returned invalid response to ID Query

BFFC0800  Error Opening File      VI_ERROR_INSTR_FILE_OPEN
BFFC0801  Error Writing to File   VI_ERROR_INSTR_FILE_WRITE
BFFC0803  Invalid Response VI_ERROR_INSTR_INTERPRETING_RESPONSE

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.

Notes:

(1) Parameter Error Codes for parameters 1 through 8 are defined in the vpptype.h header file the range is BFFC0001 - BFFC0008; for parameter errors greater than 8, and other instrument specific error codes, use an error code in the range of BFFC0900 to BFFC0FFF.  This is equivalent to using (VI_INSTR_ERROR_OFFSET + n); where n represents each instrument specific error number.  Valid ranges for n are 0 to 6FF.  (All values are given in Hexadecimal Notation)

(2) Delete all unused status codes from the Status Control of each function panel when you are finished development of your instrument driver, for example in this control the status codes for parameters 1, 3-8, and the codes for Error Opening and Writing to File should be deleted.  Those status codes are provided here as a convenience for during driver development.  

(3) Delete these three (3) notes when you are finished with your driver development.              Instrument Handle                 ͛       Status                                    Mode                                   	           	                This function controls the status of the Card Pairing feature. See the instrument manuals for details concerning this feature.

/* Function prorotype */

ViStatus Ki7001_EnableCardPairing(
    ViSession instrumentHandle,
    ViInt16 enable);
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    
    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFC0101  ID Query not supported - VI_WARN_NSUP_ID_QUERY   
3FFC0102  Reset not supported - VI_WARN_NSUP_RESET      
3FFC0103  Self Test not supported - VI_WARN_NSUP_SELF_TEST  
3FFC0104  Error Query not supported - VI_WARN_NSUP_ERROR_QUERY
3FFC0105  Revision Query not supported - VI_WARN_NSUP_REV_QUERY  
3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0001  Parameter 1 out of range. (String not range checked)
BFFC0002  Parameter 2 (ID Query) out of range.
BFFC0003  Parameter 3 (Reset Device) out of range.
BFFC0004  Parameter 4 out of range.
BFFC0005  Parameter 5 out of range.
BFFC0006  Parameter 6 out of range.
BFFC0007  Parameter 7 out of range.
BFFC0008  Parameter 8 out of range.
BFFC0011  Instrument returned invalid response to ID Query

BFFC0800  Error Opening File      VI_ERROR_INSTR_FILE_OPEN
BFFC0801  Error Writing to File   VI_ERROR_INSTR_FILE_WRITE
BFFC0803  Invalid Response VI_ERROR_INSTR_INTERPRETING_RESPONSE

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.

Notes:

(1) Parameter Error Codes for parameters 1 through 8 are defined in the vpptype.h header file the range is BFFC0001 - BFFC0008; for parameter errors greater than 8, and other instrument specific error codes, use an error code in the range of BFFC0900 to BFFC0FFF.  This is equivalent to using (VI_INSTR_ERROR_OFFSET + n); where n represents each instrument specific error number.  Valid ranges for n are 0 to 6FF.  (All values are given in Hexadecimal Notation)

(2) Delete all unused status codes from the Status Control of each function panel when you are finished development of your instrument driver, for example in this control the status codes for parameters 1, 3-8, and the codes for Error Opening and Writing to File should be deleted.  Those status codes are provided here as a convenience for during driver development.  

(3) Delete these three (3) notes when you are finished with your driver development.     !         Instrument Handle                 ڱ !      Status                           !       Enable                                 	                     Yes 1 No 0        This function return the actual status of the Card Pairing feature.

/* function prototype */

ViStatus Ki7001_QueryCardPairing(
    ViSession instrumentHandle, 
    ViInt16 *mode);
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    
    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFC0101  ID Query not supported - VI_WARN_NSUP_ID_QUERY   
3FFC0102  Reset not supported - VI_WARN_NSUP_RESET      
3FFC0103  Self Test not supported - VI_WARN_NSUP_SELF_TEST  
3FFC0104  Error Query not supported - VI_WARN_NSUP_ERROR_QUERY
3FFC0105  Revision Query not supported - VI_WARN_NSUP_REV_QUERY  
3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0001  Parameter 1 out of range. (String not range checked)
BFFC0002  Parameter 2 (ID Query) out of range.
BFFC0003  Parameter 3 (Reset Device) out of range.
BFFC0004  Parameter 4 out of range.
BFFC0005  Parameter 5 out of range.
BFFC0006  Parameter 6 out of range.
BFFC0007  Parameter 7 out of range.
BFFC0008  Parameter 8 out of range.
BFFC0011  Instrument returned invalid response to ID Query

BFFC0800  Error Opening File      VI_ERROR_INSTR_FILE_OPEN
BFFC0801  Error Writing to File   VI_ERROR_INSTR_FILE_WRITE
BFFC0803  Invalid Response VI_ERROR_INSTR_INTERPRETING_RESPONSE

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.

Notes:

(1) Parameter Error Codes for parameters 1 through 8 are defined in the vpptype.h header file the range is BFFC0001 - BFFC0008; for parameter errors greater than 8, and other instrument specific error codes, use an error code in the range of BFFC0900 to BFFC0FFF.  This is equivalent to using (VI_INSTR_ERROR_OFFSET + n); where n represents each instrument specific error number.  Valid ranges for n are 0 to 6FF.  (All values are given in Hexadecimal Notation)

(2) Delete all unused status codes from the Status Control of each function panel when you are finished development of your instrument driver, for example in this control the status codes for parameters 1, 3-8, and the codes for Error Opening and Writing to File should be deleted.  Those status codes are provided here as a convenience for during driver development.  

(3) Delete these three (3) notes when you are finished with your driver development.      
        Instrument Handle                        Status                                    Mode                                   	           	                This function allows you to read the digital input lines of the instrument.

/* Function prototype */

ViStatus Ki7001_TTLInput(
    ViSession instrumentHandle, 
    ViInt16 *result, 
    int origin);
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    
    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFC0101  ID Query not supported - VI_WARN_NSUP_ID_QUERY   
3FFC0102  Reset not supported - VI_WARN_NSUP_RESET      
3FFC0103  Self Test not supported - VI_WARN_NSUP_SELF_TEST  
3FFC0104  Error Query not supported - VI_WARN_NSUP_ERROR_QUERY
3FFC0105  Revision Query not supported - VI_WARN_NSUP_REV_QUERY  
3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0001  Parameter 1 out of range. (String not range checked)
BFFC0002  Parameter 2 (ID Query) out of range.
BFFC0003  Parameter 3 (Reset Device) out of range.
BFFC0004  Parameter 4 out of range.
BFFC0005  Parameter 5 out of range.
BFFC0006  Parameter 6 out of range.
BFFC0007  Parameter 7 out of range.
BFFC0008  Parameter 8 out of range.
BFFC0011  Instrument returned invalid response to ID Query

BFFC0800  Error Opening File      VI_ERROR_INSTR_FILE_OPEN
BFFC0801  Error Writing to File   VI_ERROR_INSTR_FILE_WRITE
BFFC0803  Invalid Response VI_ERROR_INSTR_INTERPRETING_RESPONSE

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.

Notes:

(1) Parameter Error Codes for parameters 1 through 8 are defined in the vpptype.h header file the range is BFFC0001 - BFFC0008; for parameter errors greater than 8, and other instrument specific error codes, use an error code in the range of BFFC0900 to BFFC0FFF.  This is equivalent to using (VI_INSTR_ERROR_OFFSET + n); where n represents each instrument specific error number.  Valid ranges for n are 0 to 6FF.  (All values are given in Hexadecimal Notation)

(2) Delete all unused status codes from the Status Control of each function panel when you are finished development of your instrument driver, for example in this control the status codes for parameters 1, 3-8, and the codes for Error Opening and Writing to File should be deleted.  Those status codes are provided here as a convenience for during driver development.  

(3) Delete these three (3) notes when you are finished with your driver development.               Instrument Handle                         Status                                    Result                                      Origin                                 	           	                       !Internal 1 Slot One 2 Slot Two 3       This function allows you to save an instrument configuration in the instrument memory, so you can retrieve it later using the RecallSetup function, or define it as the default setup when the instrument is powered on. Do not confuse these setups with the relay patterns memory.

/* Function prototype */

ViStatus Ki7001_SaveSetup(
    ViSession instrumentHandle,
    ViInt16 setupNumber);

         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    
    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFC0101  ID Query not supported - VI_WARN_NSUP_ID_QUERY   
3FFC0102  Reset not supported - VI_WARN_NSUP_RESET      
3FFC0103  Self Test not supported - VI_WARN_NSUP_SELF_TEST  
3FFC0104  Error Query not supported - VI_WARN_NSUP_ERROR_QUERY
3FFC0105  Revision Query not supported - VI_WARN_NSUP_REV_QUERY  
3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0001  Parameter 1 out of range. (String not range checked)
BFFC0002  Parameter 2 (ID Query) out of range.
BFFC0003  Parameter 3 (Reset Device) out of range.
BFFC0004  Parameter 4 out of range.
BFFC0005  Parameter 5 out of range.
BFFC0006  Parameter 6 out of range.
BFFC0007  Parameter 7 out of range.
BFFC0008  Parameter 8 out of range.
BFFC0011  Instrument returned invalid response to ID Query

BFFC0800  Error Opening File      VI_ERROR_INSTR_FILE_OPEN
BFFC0801  Error Writing to File   VI_ERROR_INSTR_FILE_WRITE
BFFC0803  Invalid Response VI_ERROR_INSTR_INTERPRETING_RESPONSE

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.

Notes:

(1) Parameter Error Codes for parameters 1 through 8 are defined in the vpptype.h header file the range is BFFC0001 - BFFC0008; for parameter errors greater than 8, and other instrument specific error codes, use an error code in the range of BFFC0900 to BFFC0FFF.  This is equivalent to using (VI_INSTR_ERROR_OFFSET + n); where n represents each instrument specific error number.  Valid ranges for n are 0 to 6FF.  (All values are given in Hexadecimal Notation)

(2) Delete all unused status codes from the Status Control of each function panel when you are finished development of your instrument driver, for example in this control the status codes for parameters 1, 3-8, and the codes for Error Opening and Writing to File should be deleted.  Those status codes are provided here as a convenience for during driver development.  

(3) Delete these three (3) notes when you are finished with your driver development.             Instrument Handle                       Status                                   Setup Number                           	              	                      This function enables you to recal a previously stored setup.

/* function prototype */

ViStatus Ki7001_RecallSetup(
    ViSession instrumentHandle,
    ViInt16 setupNumber);
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    
    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFC0101  ID Query not supported - VI_WARN_NSUP_ID_QUERY   
3FFC0102  Reset not supported - VI_WARN_NSUP_RESET      
3FFC0103  Self Test not supported - VI_WARN_NSUP_SELF_TEST  
3FFC0104  Error Query not supported - VI_WARN_NSUP_ERROR_QUERY
3FFC0105  Revision Query not supported - VI_WARN_NSUP_REV_QUERY  
3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0001  Parameter 1 out of range. (String not range checked)
BFFC0002  Parameter 2 (ID Query) out of range.
BFFC0003  Parameter 3 (Reset Device) out of range.
BFFC0004  Parameter 4 out of range.
BFFC0005  Parameter 5 out of range.
BFFC0006  Parameter 6 out of range.
BFFC0007  Parameter 7 out of range.
BFFC0008  Parameter 8 out of range.
BFFC0011  Instrument returned invalid response to ID Query

BFFC0800  Error Opening File      VI_ERROR_INSTR_FILE_OPEN
BFFC0801  Error Writing to File   VI_ERROR_INSTR_FILE_WRITE
BFFC0803  Invalid Response VI_ERROR_INSTR_INTERPRETING_RESPONSE

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.

Notes:

(1) Parameter Error Codes for parameters 1 through 8 are defined in the vpptype.h header file the range is BFFC0001 - BFFC0008; for parameter errors greater than 8, and other instrument specific error codes, use an error code in the range of BFFC0900 to BFFC0FFF.  This is equivalent to using (VI_INSTR_ERROR_OFFSET + n); where n represents each instrument specific error number.  Valid ranges for n are 0 to 6FF.  (All values are given in Hexadecimal Notation)

(2) Delete all unused status codes from the Status Control of each function panel when you are finished development of your instrument driver, for example in this control the status codes for parameters 1, 3-8, and the codes for Error Opening and Writing to File should be deleted.  Those status codes are provided here as a convenience for during driver development.  

(3) Delete these three (3) notes when you are finished with your driver development.     	        Instrument Handle                t       Status                                   Setup Number                           	              	                      This function gives you the control of the default setup used by the instrument at each time it is powered up.

/* Function prototype */

ViStatus Ki7001_POSetup(
    ViSession instrumentHandle,
    ViInt16 setup);
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    
    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFC0101  ID Query not supported - VI_WARN_NSUP_ID_QUERY   
3FFC0102  Reset not supported - VI_WARN_NSUP_RESET      
3FFC0103  Self Test not supported - VI_WARN_NSUP_SELF_TEST  
3FFC0104  Error Query not supported - VI_WARN_NSUP_ERROR_QUERY
3FFC0105  Revision Query not supported - VI_WARN_NSUP_REV_QUERY  
3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0001  Parameter 1 out of range. (String not range checked)
BFFC0002  Parameter 2 (ID Query) out of range.
BFFC0003  Parameter 3 (Reset Device) out of range.
BFFC0004  Parameter 4 out of range.
BFFC0005  Parameter 5 out of range.
BFFC0006  Parameter 6 out of range.
BFFC0007  Parameter 7 out of range.
BFFC0008  Parameter 8 out of range.
BFFC0011  Instrument returned invalid response to ID Query

BFFC0800  Error Opening File      VI_ERROR_INSTR_FILE_OPEN
BFFC0801  Error Writing to File   VI_ERROR_INSTR_FILE_WRITE
BFFC0803  Invalid Response VI_ERROR_INSTR_INTERPRETING_RESPONSE

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.

Notes:

(1) Parameter Error Codes for parameters 1 through 8 are defined in the vpptype.h header file the range is BFFC0001 - BFFC0008; for parameter errors greater than 8, and other instrument specific error codes, use an error code in the range of BFFC0900 to BFFC0FFF.  This is equivalent to using (VI_INSTR_ERROR_OFFSET + n); where n represents each instrument specific error number.  Valid ranges for n are 0 to 6FF.  (All values are given in Hexadecimal Notation)

(2) Delete all unused status codes from the Status Control of each function panel when you are finished development of your instrument driver, for example in this control the status codes for parameters 1, 3-8, and the codes for Error Opening and Writing to File should be deleted.  Those status codes are provided here as a convenience for during driver development.  

(3) Delete these three (3) notes when you are finished with your driver development.    ! 	        Instrument Handle                z !      Status                           !J       Setup                                  	                      RST Conditions -2 :SYST:PRES Conditions -1 User Setup 0 0 User Setup 1 1 User Setup 2 2 User Setup 3 3 User Setup 4 4 User Setup 5 5 User Setup 6 6 User Setup 7 7 User Setup 8 8 User Setup 9 9       This function allows the user to close one or more relays on any card installed in any slot of the scanner.

The channel list parameter is a string representing the list of channels to close. This string must follow specific rules as described below :

1!2!4 : Single Channel (Slot1, Row 2, Column 4)
2!36 : Single Channel (Slot 2, Channel 36)
1!6,1!18,2!3!6 : Multiple channels separated by commas.
1!2:1!10 : Range of channels ( 2 through 10 on slot 1)
1!2:1!10,2!3!6 : Range of channels and a single channel.
1!30:1!40,2!1:2:10 : Range of multiplex channels
1!4!1:1!4!10, 2!1!1:2!1!10 : Range of matrix channels
M36 : Channel pattern storead at memory location 36.

You can also use the helpers functions to create these lists. These helpers are : 

char *Ki7001_MAKESCANCHAN (char *buffer, int slot, int row, int column);
char *Ki7001_MAKEMUXCHAN (char *buffer, int slot, int channel);
char *Ki7001_MAKEMEMCHAN (char *buffer, int memory);
char *Ki7001_MAKECONTIGUOUSLIST (char *buffer, char *start, char *stop);
char *Ki7001_ADDTOLIST (char *buffer, char *actual, char *new);

/* Function Prototype */

ViStatus Ki7001_Close(
    ViSession instrumentHandle, 
    ViChar channelList[]);


         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    
    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFC0101  ID Query not supported - VI_WARN_NSUP_ID_QUERY   
3FFC0102  Reset not supported - VI_WARN_NSUP_RESET      
3FFC0103  Self Test not supported - VI_WARN_NSUP_SELF_TEST  
3FFC0104  Error Query not supported - VI_WARN_NSUP_ERROR_QUERY
3FFC0105  Revision Query not supported - VI_WARN_NSUP_REV_QUERY  
3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0001  Parameter 1 out of range. (String not range checked)
BFFC0002  Parameter 2 (ID Query) out of range.
BFFC0003  Parameter 3 (Reset Device) out of range.
BFFC0004  Parameter 4 out of range.
BFFC0005  Parameter 5 out of range.
BFFC0006  Parameter 6 out of range.
BFFC0007  Parameter 7 out of range.
BFFC0008  Parameter 8 out of range.
BFFC0011  Instrument returned invalid response to ID Query

BFFC0800  Error Opening File      VI_ERROR_INSTR_FILE_OPEN
BFFC0801  Error Writing to File   VI_ERROR_INSTR_FILE_WRITE
BFFC0803  Invalid Response VI_ERROR_INSTR_INTERPRETING_RESPONSE

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.

Notes:

(1) Parameter Error Codes for parameters 1 through 8 are defined in the vpptype.h header file the range is BFFC0001 - BFFC0008; for parameter errors greater than 8, and other instrument specific error codes, use an error code in the range of BFFC0900 to BFFC0FFF.  This is equivalent to using (VI_INSTR_ERROR_OFFSET + n); where n represents each instrument specific error number.  Valid ranges for n are 0 to 6FF.  (All values are given in Hexadecimal Notation)

(2) Delete all unused status codes from the Status Control of each function panel when you are finished development of your instrument driver, for example in this control the status codes for parameters 1, 3-8, and the codes for Error Opening and Writing to File should be deleted.  Those status codes are provided here as a convenience for during driver development.  

(3) Delete these three (3) notes when you are finished with your driver development.   -k "         Instrument Handle                .
        Status                           Z       Channel List                           	                  This function allows the user to open one or more relays on any card installed in any slot of the scanner.

The channel list parameter is a string representing the list of channels to close. This string must follow specific rules as described below :

1!2!4 : Single Channel (Slot1, Row 2, Column 4)
2!36 : Single Channel (Slot 2, Channel 36)
1!6,1!18,2!3!6 : Multiple channels separated by commas.
1!2:1!10 : Range of channels ( 2 through 10 on slot 1)
1!2:1!10,2!3!6 : Range of channels and a single channel.
1!30:1!40,2!1:2:10 : Range of multiplex channels
1!4!1:1!4!10, 2!1!1:2!1!10 : Range of matrix channels
M36 : Channel pattern storead at memory location 36.

You can also use the helpers functions to create these lists. These helpers are : 

char *Ki7001_MAKESCANCHAN (char *buffer, int slot, int row, int column);
char *Ki7001_MAKEMUXCHAN (char *buffer, int slot, int channel);
char *Ki7001_MAKEMEMCHAN (char *buffer, int memory);
char *Ki7001_MAKECONTIGUOUSLIST (char *buffer, char *start, char *stop);
char *Ki7001_ADDTOLIST (char *buffer, char *actual, char *new);

/* Function Prototype */

ViStatus Ki7001_Open(
    ViSession instrumentHandle, 
    ViChar channelList[]);
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    
    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFC0101  ID Query not supported - VI_WARN_NSUP_ID_QUERY   
3FFC0102  Reset not supported - VI_WARN_NSUP_RESET      
3FFC0103  Self Test not supported - VI_WARN_NSUP_SELF_TEST  
3FFC0104  Error Query not supported - VI_WARN_NSUP_ERROR_QUERY
3FFC0105  Revision Query not supported - VI_WARN_NSUP_REV_QUERY  
3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0001  Parameter 1 out of range. (String not range checked)
BFFC0002  Parameter 2 (ID Query) out of range.
BFFC0003  Parameter 3 (Reset Device) out of range.
BFFC0004  Parameter 4 out of range.
BFFC0005  Parameter 5 out of range.
BFFC0006  Parameter 6 out of range.
BFFC0007  Parameter 7 out of range.
BFFC0008  Parameter 8 out of range.
BFFC0011  Instrument returned invalid response to ID Query

BFFC0800  Error Opening File      VI_ERROR_INSTR_FILE_OPEN
BFFC0801  Error Writing to File   VI_ERROR_INSTR_FILE_WRITE
BFFC0803  Invalid Response VI_ERROR_INSTR_INTERPRETING_RESPONSE

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.

Notes:

(1) Parameter Error Codes for parameters 1 through 8 are defined in the vpptype.h header file the range is BFFC0001 - BFFC0008; for parameter errors greater than 8, and other instrument specific error codes, use an error code in the range of BFFC0900 to BFFC0FFF.  This is equivalent to using (VI_INSTR_ERROR_OFFSET + n); where n represents each instrument specific error number.  Valid ranges for n are 0 to 6FF.  (All values are given in Hexadecimal Notation)

(2) Delete all unused status codes from the Status Control of each function panel when you are finished development of your instrument driver, for example in this control the status codes for parameters 1, 3-8, and the codes for Error Opening and Writing to File should be deleted.  Those status codes are provided here as a convenience for during driver development.  

(3) Delete these three (3) notes when you are finished with your driver development.   >+ &         Instrument Handle                >        Status                           c       Channel List                           	                   This function open al the actually closed channels.

/* Function prototype */

ViStatus Ki7001_OpenAll (ViSession instrumentHandle);
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    
    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFC0101  ID Query not supported - VI_WARN_NSUP_ID_QUERY   
3FFC0102  Reset not supported - VI_WARN_NSUP_RESET      
3FFC0103  Self Test not supported - VI_WARN_NSUP_SELF_TEST  
3FFC0104  Error Query not supported - VI_WARN_NSUP_ERROR_QUERY
3FFC0105  Revision Query not supported - VI_WARN_NSUP_REV_QUERY  
3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0001  Parameter 1 out of range. (String not range checked)
BFFC0002  Parameter 2 (ID Query) out of range.
BFFC0003  Parameter 3 (Reset Device) out of range.
BFFC0004  Parameter 4 out of range.
BFFC0005  Parameter 5 out of range.
BFFC0006  Parameter 6 out of range.
BFFC0007  Parameter 7 out of range.
BFFC0008  Parameter 8 out of range.
BFFC0011  Instrument returned invalid response to ID Query

BFFC0800  Error Opening File      VI_ERROR_INSTR_FILE_OPEN
BFFC0801  Error Writing to File   VI_ERROR_INSTR_FILE_WRITE
BFFC0803  Invalid Response VI_ERROR_INSTR_INTERPRETING_RESPONSE

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.

Notes:

(1) Parameter Error Codes for parameters 1 through 8 are defined in the vpptype.h header file the range is BFFC0001 - BFFC0008; for parameter errors greater than 8, and other instrument specific error codes, use an error code in the range of BFFC0900 to BFFC0FFF.  This is equivalent to using (VI_INSTR_ERROR_OFFSET + n); where n represents each instrument specific error number.  Valid ranges for n are 0 to 6FF.  (All values are given in Hexadecimal Notation)

(2) Delete all unused status codes from the Status Control of each function panel when you are finished development of your instrument driver, for example in this control the status codes for parameters 1, 3-8, and the codes for Error Opening and Writing to File should be deleted.  Those status codes are provided here as a convenience for during driver development.  

(3) Delete these three (3) notes when you are finished with your driver development.   J           Instrument Handle                Kk        Status                                 	              This function allows the user to define a scan list of one or more relays on any card installed in any slot of the scanner.

The channel list parameter is a string representing the list of channels to close. This string must follow specific rules as described below :

1!2!4 : Single Channel (Slot1, Row 2, Column 4)
2!36 : Single Channel (Slot 2, Channel 36)
1!6,1!18,2!3!6 : Multiple channels separated by commas.
1!2:1!10 : Range of channels ( 2 through 10 on slot 1)
1!2:1!10,2!3!6 : Range of channels and a single channel.
1!30:1!40,2!1:2:10 : Range of multiplex channels
1!4!1:1!4!10, 2!1!1:2!1!10 : Range of matrix channels
M36 : Channel pattern storead at memory location 36.

You can also use the helpers functions to create these lists. These helpers are : 

char *Ki7001_MAKESCANCHAN (char *buffer, int slot, int row, int column);
char *Ki7001_MAKEMUXCHAN (char *buffer, int slot, int channel);
char *Ki7001_MAKEMEMCHAN (char *buffer, int memory);
char *Ki7001_MAKECONTIGUOUSLIST (char *buffer, char *start, char *stop);
char *Ki7001_ADDTOLIST (char *buffer, char *actual, char *new);

/* Function Prototype */

ViStatus Ki7001_ScanList(
    ViSession instrumentHandle, 
    ViChar channelList[]);
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    
    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFC0101  ID Query not supported - VI_WARN_NSUP_ID_QUERY   
3FFC0102  Reset not supported - VI_WARN_NSUP_RESET      
3FFC0103  Self Test not supported - VI_WARN_NSUP_SELF_TEST  
3FFC0104  Error Query not supported - VI_WARN_NSUP_ERROR_QUERY
3FFC0105  Revision Query not supported - VI_WARN_NSUP_REV_QUERY  
3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0001  Parameter 1 out of range. (String not range checked)
BFFC0002  Parameter 2 (ID Query) out of range.
BFFC0003  Parameter 3 (Reset Device) out of range.
BFFC0004  Parameter 4 out of range.
BFFC0005  Parameter 5 out of range.
BFFC0006  Parameter 6 out of range.
BFFC0007  Parameter 7 out of range.
BFFC0008  Parameter 8 out of range.
BFFC0011  Instrument returned invalid response to ID Query

BFFC0800  Error Opening File      VI_ERROR_INSTR_FILE_OPEN
BFFC0801  Error Writing to File   VI_ERROR_INSTR_FILE_WRITE
BFFC0803  Invalid Response VI_ERROR_INSTR_INTERPRETING_RESPONSE

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.

Notes:

(1) Parameter Error Codes for parameters 1 through 8 are defined in the vpptype.h header file the range is BFFC0001 - BFFC0008; for parameter errors greater than 8, and other instrument specific error codes, use an error code in the range of BFFC0900 to BFFC0FFF.  This is equivalent to using (VI_INSTR_ERROR_OFFSET + n); where n represents each instrument specific error number.  Valid ranges for n are 0 to 6FF.  (All values are given in Hexadecimal Notation)

(2) Delete all unused status codes from the Status Control of each function panel when you are finished development of your instrument driver, for example in this control the status codes for parameters 1, 3-8, and the codes for Error Opening and Writing to File should be deleted.  Those status codes are provided here as a convenience for during driver development.  

(3) Delete these three (3) notes when you are finished with your driver development.   [h %         Instrument Handle                \        Status                           _       Channel List                           	              q    This function sore the current relays status (Close or open) in one of the 100 relay pattern memory locations. After this pattern has been saved, it can be recalled by the RecalPattern Function or used to define a close, open or scna list of relays.

/* Function prototype */

ViStatus Ki7001_StoreRelayPattern(
    ViSession instrumentHandle, 
    ViInt16 pattern);
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    
    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFC0101  ID Query not supported - VI_WARN_NSUP_ID_QUERY   
3FFC0102  Reset not supported - VI_WARN_NSUP_RESET      
3FFC0103  Self Test not supported - VI_WARN_NSUP_SELF_TEST  
3FFC0104  Error Query not supported - VI_WARN_NSUP_ERROR_QUERY
3FFC0105  Revision Query not supported - VI_WARN_NSUP_REV_QUERY  
3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0001  Parameter 1 out of range. (String not range checked)
BFFC0002  Parameter 2 (ID Query) out of range.
BFFC0003  Parameter 3 (Reset Device) out of range.
BFFC0004  Parameter 4 out of range.
BFFC0005  Parameter 5 out of range.
BFFC0006  Parameter 6 out of range.
BFFC0007  Parameter 7 out of range.
BFFC0008  Parameter 8 out of range.
BFFC0011  Instrument returned invalid response to ID Query

BFFC0800  Error Opening File      VI_ERROR_INSTR_FILE_OPEN
BFFC0801  Error Writing to File   VI_ERROR_INSTR_FILE_WRITE
BFFC0803  Invalid Response VI_ERROR_INSTR_INTERPRETING_RESPONSE

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.

Notes:

(1) Parameter Error Codes for parameters 1 through 8 are defined in the vpptype.h header file the range is BFFC0001 - BFFC0008; for parameter errors greater than 8, and other instrument specific error codes, use an error code in the range of BFFC0900 to BFFC0FFF.  This is equivalent to using (VI_INSTR_ERROR_OFFSET + n); where n represents each instrument specific error number.  Valid ranges for n are 0 to 6FF.  (All values are given in Hexadecimal Notation)

(2) Delete all unused status codes from the Status Control of each function panel when you are finished development of your instrument driver, for example in this control the status codes for parameters 1, 3-8, and the codes for Error Opening and Writing to File should be deleted.  Those status codes are provided here as a convenience for during driver development.  

(3) Delete these three (3) notes when you are finished with your driver development.   h "         Instrument Handle                i "      Status                           "        Pattern                                	              d                     This function recall a relay pattern prevuioulsly stored in a relay pattern memory location.

/* Function prototype */

ViStatus Ki7001_RecallRelayPattern(
    ViSession instrumentHandle, 
    ViInt16 pattern);
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    
    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFC0101  ID Query not supported - VI_WARN_NSUP_ID_QUERY   
3FFC0102  Reset not supported - VI_WARN_NSUP_RESET      
3FFC0103  Self Test not supported - VI_WARN_NSUP_SELF_TEST  
3FFC0104  Error Query not supported - VI_WARN_NSUP_ERROR_QUERY
3FFC0105  Revision Query not supported - VI_WARN_NSUP_REV_QUERY  
3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0001  Parameter 1 out of range. (String not range checked)
BFFC0002  Parameter 2 (ID Query) out of range.
BFFC0003  Parameter 3 (Reset Device) out of range.
BFFC0004  Parameter 4 out of range.
BFFC0005  Parameter 5 out of range.
BFFC0006  Parameter 6 out of range.
BFFC0007  Parameter 7 out of range.
BFFC0008  Parameter 8 out of range.
BFFC0011  Instrument returned invalid response to ID Query

BFFC0800  Error Opening File      VI_ERROR_INSTR_FILE_OPEN
BFFC0801  Error Writing to File   VI_ERROR_INSTR_FILE_WRITE
BFFC0803  Invalid Response VI_ERROR_INSTR_INTERPRETING_RESPONSE

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.

Notes:

(1) Parameter Error Codes for parameters 1 through 8 are defined in the vpptype.h header file the range is BFFC0001 - BFFC0008; for parameter errors greater than 8, and other instrument specific error codes, use an error code in the range of BFFC0900 to BFFC0FFF.  This is equivalent to using (VI_INSTR_ERROR_OFFSET + n); where n represents each instrument specific error number.  Valid ranges for n are 0 to 6FF.  (All values are given in Hexadecimal Notation)

(2) Delete all unused status codes from the Status Control of each function panel when you are finished development of your instrument driver, for example in this control the status codes for parameters 1, 3-8, and the codes for Error Opening and Writing to File should be deleted.  Those status codes are provided here as a convenience for during driver development.  

(3) Delete these three (3) notes when you are finished with your driver development.   u $         Instrument Handle                $        Pattern                          v $      Status                                    d                 	           y    This function gives you a way to write to any instrument registers.
See 7001 Manual : Status Structure (Pages 5-5, 5-6)         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    
    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFC0101  ID Query not supported - VI_WARN_NSUP_ID_QUERY   
3FFC0102  Reset not supported - VI_WARN_NSUP_RESET      
3FFC0103  Self Test not supported - VI_WARN_NSUP_SELF_TEST  
3FFC0104  Error Query not supported - VI_WARN_NSUP_ERROR_QUERY
3FFC0105  Revision Query not supported - VI_WARN_NSUP_REV_QUERY  
3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0001  Parameter 1 out of range. (String not range checked)
BFFC0002  Parameter 2 (ID Query) out of range.
BFFC0003  Parameter 3 (Reset Device) out of range.
BFFC0004  Parameter 4 out of range.
BFFC0005  Parameter 5 out of range.
BFFC0006  Parameter 6 out of range.
BFFC0007  Parameter 7 out of range.
BFFC0008  Parameter 8 out of range.
BFFC0011  Instrument returned invalid response to ID Query

BFFC0800  Error Opening File      VI_ERROR_INSTR_FILE_OPEN
BFFC0801  Error Writing to File   VI_ERROR_INSTR_FILE_WRITE
BFFC0803  Invalid Response VI_ERROR_INSTR_INTERPRETING_RESPONSE

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.

Notes:

(1) Parameter Error Codes for parameters 1 through 8 are defined in the vpptype.h header file the range is BFFC0001 - BFFC0008; for parameter errors greater than 8, and other instrument specific error codes, use an error code in the range of BFFC0900 to BFFC0FFF.  This is equivalent to using (VI_INSTR_ERROR_OFFSET + n); where n represents each instrument specific error number.  Valid ranges for n are 0 to 6FF.  (All values are given in Hexadecimal Notation)

(2) Delete all unused status codes from the Status Control of each function panel when you are finished development of your instrument driver, for example in this control the status codes for parameters 1, 3-8, and the codes for Error Opening and Writing to File should be deleted.  Those status codes are provided here as a convenience for during driver development.  

(3) Delete these three (3) notes when you are finished with your driver development.             Instrument Handle                :       Status                           r       Reg                              v )       Value                                  	                     Service Request Enable Register 0 Standard Event Status Enable Register 1 Operation Event Enable Register 2 Operation Transition Register 3 Arm Event Enable Register 4 Arm Transition Register 5 Sequence Event Enable Register 6 Sequence Transition Register 7 Questionable Event Enable Register 8 Questionable Transition Register 9 Trigger Event Enable Register 10 Trigger Transition Register 11                         u    This function gives you a way to erad any instrument registers.
See 7001 Manual : Status Structure (Pages 5-5, 5-6)         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    
    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFC0101  ID Query not supported - VI_WARN_NSUP_ID_QUERY   
3FFC0102  Reset not supported - VI_WARN_NSUP_RESET      
3FFC0103  Self Test not supported - VI_WARN_NSUP_SELF_TEST  
3FFC0104  Error Query not supported - VI_WARN_NSUP_ERROR_QUERY
3FFC0105  Revision Query not supported - VI_WARN_NSUP_REV_QUERY  
3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0001  Parameter 1 out of range. (String not range checked)
BFFC0002  Parameter 2 (ID Query) out of range.
BFFC0003  Parameter 3 (Reset Device) out of range.
BFFC0004  Parameter 4 out of range.
BFFC0005  Parameter 5 out of range.
BFFC0006  Parameter 6 out of range.
BFFC0007  Parameter 7 out of range.
BFFC0008  Parameter 8 out of range.
BFFC0011  Instrument returned invalid response to ID Query

BFFC0800  Error Opening File      VI_ERROR_INSTR_FILE_OPEN
BFFC0801  Error Writing to File   VI_ERROR_INSTR_FILE_WRITE
BFFC0803  Invalid Response VI_ERROR_INSTR_INTERPRETING_RESPONSE

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.

Notes:

(1) Parameter Error Codes for parameters 1 through 8 are defined in the vpptype.h header file the range is BFFC0001 - BFFC0008; for parameter errors greater than 8, and other instrument specific error codes, use an error code in the range of BFFC0900 to BFFC0FFF.  This is equivalent to using (VI_INSTR_ERROR_OFFSET + n); where n represents each instrument specific error number.  Valid ranges for n are 0 to 6FF.  (All values are given in Hexadecimal Notation)

(2) Delete all unused status codes from the Status Control of each function panel when you are finished development of your instrument driver, for example in this control the status codes for parameters 1, 3-8, and the codes for Error Opening and Writing to File should be deleted.  Those status codes are provided here as a convenience for during driver development.  

(3) Delete these three (3) notes when you are finished with your driver development.             Instrument Handle                "      Status                           p       Reg                                      Value                                  	                     Service Request Enable Register 0 Standard Event Status Enable Register 1 Operation Event Enable Register 2 Operation Transition Register 3 Arm Event Enable Register 4 Arm Transition Register 5 Sequence Event Enable Register 6 Sequence Transition Register 7 Questionable Event Enable Register 8 Questionable Transition Register 9 Trigger Event Enable Register 10 Trigger Transition Register 11 Status Byte Register 12 Standard Event Status Register 13 Operation Event Register 14 Operation Condition Register 15 Arm Event Register 16 Arm Condition Register 17 Sequence Event Register 18 Sequence Condition Register 19 Questionable Event Register 20 Questionable Condition Register 21 Trigger Event Register 22 Trigger Condition Register 23    	            e    This function clear all the registers. 5 the error message queue is not cleared by this function).
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    
    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFC0101  ID Query not supported - VI_WARN_NSUP_ID_QUERY   
3FFC0102  Reset not supported - VI_WARN_NSUP_RESET      
3FFC0103  Self Test not supported - VI_WARN_NSUP_SELF_TEST  
3FFC0104  Error Query not supported - VI_WARN_NSUP_ERROR_QUERY
3FFC0105  Revision Query not supported - VI_WARN_NSUP_REV_QUERY  
3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0001  Parameter 1 out of range. (String not range checked)
BFFC0002  Parameter 2 (ID Query) out of range.
BFFC0003  Parameter 3 (Reset Device) out of range.
BFFC0004  Parameter 4 out of range.
BFFC0005  Parameter 5 out of range.
BFFC0006  Parameter 6 out of range.
BFFC0007  Parameter 7 out of range.
BFFC0008  Parameter 8 out of range.
BFFC0011  Instrument returned invalid response to ID Query

BFFC0800  Error Opening File      VI_ERROR_INSTR_FILE_OPEN
BFFC0801  Error Writing to File   VI_ERROR_INSTR_FILE_WRITE
BFFC0803  Invalid Response VI_ERROR_INSTR_INTERPRETING_RESPONSE

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.

Notes:

(1) Parameter Error Codes for parameters 1 through 8 are defined in the vpptype.h header file the range is BFFC0001 - BFFC0008; for parameter errors greater than 8, and other instrument specific error codes, use an error code in the range of BFFC0900 to BFFC0FFF.  This is equivalent to using (VI_INSTR_ERROR_OFFSET + n); where n represents each instrument specific error number.  Valid ranges for n are 0 to 6FF.  (All values are given in Hexadecimal Notation)

(2) Delete all unused status codes from the Status Control of each function panel when you are finished development of your instrument driver, for example in this control the status codes for parameters 1, 3-8, and the codes for Error Opening and Writing to File should be deleted.  Those status codes are provided here as a convenience for during driver development.  

(3) Delete these three (3) notes when you are finished with your driver development.             Instrument Handle                Y       Status                                 	          \    This function gives you the capability to program SRQ emission condition without dealing directly with the registers.

Possible values : 
    - 0 :         Clear all SRQ condition
    - 1 :         SRQ on in Trigger Layer
    - 2 :         SRQ on in Arm layer 1
    - 4 :         SRQ on in Arm Layer 2
    - 8 :         SRQ on Settling
    - 16 :       SRQ on Idle
    - 32 :       SRQ on Error Available
    - 64 :       SRQ on Message Available
    - 128 :     SRQ on Operation Complete
    - 256 :     SRQ on Request Control
    - 512 :     SRQ on Device Specific Error
    - 1024 :   SRQ on Execution Error
    - 2048 :   SRQ on Command Error
    - 4096 :   SRQ on User Request 

If you want to set multiple condition then simply add each conditions values.
Example : To generate SRQ on Idle and in Trigger Layer conditions :
Enter  the value 17 (16 +1).         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    
    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFC0101  ID Query not supported - VI_WARN_NSUP_ID_QUERY   
3FFC0102  Reset not supported - VI_WARN_NSUP_RESET      
3FFC0103  Self Test not supported - VI_WARN_NSUP_SELF_TEST  
3FFC0104  Error Query not supported - VI_WARN_NSUP_ERROR_QUERY
3FFC0105  Revision Query not supported - VI_WARN_NSUP_REV_QUERY  
3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0001  Parameter 1 out of range. (String not range checked)
BFFC0002  Parameter 2 (ID Query) out of range.
BFFC0003  Parameter 3 (Reset Device) out of range.
BFFC0004  Parameter 4 out of range.
BFFC0005  Parameter 5 out of range.
BFFC0006  Parameter 6 out of range.
BFFC0007  Parameter 7 out of range.
BFFC0008  Parameter 8 out of range.
BFFC0011  Instrument returned invalid response to ID Query

BFFC0800  Error Opening File      VI_ERROR_INSTR_FILE_OPEN
BFFC0801  Error Writing to File   VI_ERROR_INSTR_FILE_WRITE
BFFC0803  Invalid Response VI_ERROR_INSTR_INTERPRETING_RESPONSE

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.

Notes:

(1) Parameter Error Codes for parameters 1 through 8 are defined in the vpptype.h header file the range is BFFC0001 - BFFC0008; for parameter errors greater than 8, and other instrument specific error codes, use an error code in the range of BFFC0900 to BFFC0FFF.  This is equivalent to using (VI_INSTR_ERROR_OFFSET + n); where n represents each instrument specific error number.  Valid ranges for n are 0 to 6FF.  (All values are given in Hexadecimal Notation)

(2) Delete all unused status codes from the Status Control of each function panel when you are finished development of your instrument driver, for example in this control the status codes for parameters 1, 3-8, and the codes for Error Opening and Writing to File should be deleted.  Those status codes are provided here as a convenience for during driver development.  

(3) Delete these three (3) notes when you are finished with your driver development.     
        Instrument Handle                       Status                           Y 
        Condition                        >                                                 	           0   Possible values : 
    - 0 :         Clear all SRQ condition
    - 1 :         SRQ on in Trigger Layer
    - 2 :         SRQ on in Arm layer 1
    - 4 :         SRQ on in Arm Layer 2
    - 8 :         SRQ on Settling
    - 16 :       SRQ on Idle
    - 32 :       SRQ on Error Available
    - 64 :       SRQ on Message Available
    - 128 :     SRQ on Operation Complete
    - 256 :     SRQ on Request Control
    - 512 :     SRQ on Device Specific Error
    - 1024 :   SRQ on Execution Error
    - 2048 :   SRQ on Command Error
    - 4096 :   SRQ on User Request 

If you want to set multiple condition then simply add each conditions values.
Example : To generate SRQ on Idle and in Trigger Layer conditions :
Enter  the value 17 (16 +1).   r    This function setup the first trigger layer called the arm layer. See the 7001 manual page 5-22 for a complete description of the SCPI trigger model

/* function prototype */

ViStatus Ki7001_SetupArmLayer
(ViSession instrumentHandle,
    ViInt16 source,
    ViInt16 count, 
    ViInt16 direction,
    ViInt16 triggerLinkInputLine,
    ViInt16 triggerLinkOutputLine);
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    
    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFC0101  ID Query not supported - VI_WARN_NSUP_ID_QUERY   
3FFC0102  Reset not supported - VI_WARN_NSUP_RESET      
3FFC0103  Self Test not supported - VI_WARN_NSUP_SELF_TEST  
3FFC0104  Error Query not supported - VI_WARN_NSUP_ERROR_QUERY
3FFC0105  Revision Query not supported - VI_WARN_NSUP_REV_QUERY  
3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0001  Parameter 1 out of range. (String not range checked)
BFFC0002  Parameter 2 (ID Query) out of range.
BFFC0003  Parameter 3 (Reset Device) out of range.
BFFC0004  Parameter 4 out of range.
BFFC0005  Parameter 5 out of range.
BFFC0006  Parameter 6 out of range.
BFFC0007  Parameter 7 out of range.
BFFC0008  Parameter 8 out of range.
BFFC0011  Instrument returned invalid response to ID Query

BFFC0800  Error Opening File      VI_ERROR_INSTR_FILE_OPEN
BFFC0801  Error Writing to File   VI_ERROR_INSTR_FILE_WRITE
BFFC0803  Invalid Response VI_ERROR_INSTR_INTERPRETING_RESPONSE

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.

Notes:

(1) Parameter Error Codes for parameters 1 through 8 are defined in the vpptype.h header file the range is BFFC0001 - BFFC0008; for parameter errors greater than 8, and other instrument specific error codes, use an error code in the range of BFFC0900 to BFFC0FFF.  This is equivalent to using (VI_INSTR_ERROR_OFFSET + n); where n represents each instrument specific error number.  Valid ranges for n are 0 to 6FF.  (All values are given in Hexadecimal Notation)

(2) Delete all unused status codes from the Status Control of each function panel when you are finished development of your instrument driver, for example in this control the status codes for parameters 1, 3-8, and the codes for Error Opening and Writing to File should be deleted.  Those status codes are provided here as a convenience for during driver development.  

(3) Delete these three (3) notes when you are finished with your driver development.     
        Instrument Handle                ?       Status                                   Source                                  Count                                   Direction                         L       Trigger Link Input Line                  Trigger Link Output Line         d                                                	                      5Immediate 0 Manual 1 Bus 2 External 3 Trigger Link 4      '                             Acceptor 0 Source 1               6Line 1 1 Line 2 2 Line 3 3 Line 4 4 Line 5 5 Line 6 6              6Line 1 1 Line 2 2 Line 3 3 Line 4 4 Line 5 5 Line 6 6    ;Choose O (zero) for the count to define an infinite count.   t    This function setup the second trigger layer called the scan layer. See the 7001 manual page 5-22 for a complete description of the SCPI trigger model

/* function prototype */

ViStatus Ki7001_SetupScanLayer
(ViSession instrumentHandle,
    ViInt16 source,
    ViInt16 count, 
    ViInt16 direction,
    ViInt16 triggerLinkInputLine,
    ViInt16 triggerLinkOutputLine);         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    
    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFC0101  ID Query not supported - VI_WARN_NSUP_ID_QUERY   
3FFC0102  Reset not supported - VI_WARN_NSUP_RESET      
3FFC0103  Self Test not supported - VI_WARN_NSUP_SELF_TEST  
3FFC0104  Error Query not supported - VI_WARN_NSUP_ERROR_QUERY
3FFC0105  Revision Query not supported - VI_WARN_NSUP_REV_QUERY  
3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0001  Parameter 1 out of range. (String not range checked)
BFFC0002  Parameter 2 (ID Query) out of range.
BFFC0003  Parameter 3 (Reset Device) out of range.
BFFC0004  Parameter 4 out of range.
BFFC0005  Parameter 5 out of range.
BFFC0006  Parameter 6 out of range.
BFFC0007  Parameter 7 out of range.
BFFC0008  Parameter 8 out of range.
BFFC0011  Instrument returned invalid response to ID Query

BFFC0800  Error Opening File      VI_ERROR_INSTR_FILE_OPEN
BFFC0801  Error Writing to File   VI_ERROR_INSTR_FILE_WRITE
BFFC0803  Invalid Response VI_ERROR_INSTR_INTERPRETING_RESPONSE

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.

Notes:

(1) Parameter Error Codes for parameters 1 through 8 are defined in the vpptype.h header file the range is BFFC0001 - BFFC0008; for parameter errors greater than 8, and other instrument specific error codes, use an error code in the range of BFFC0900 to BFFC0FFF.  This is equivalent to using (VI_INSTR_ERROR_OFFSET + n); where n represents each instrument specific error number.  Valid ranges for n are 0 to 6FF.  (All values are given in Hexadecimal Notation)

(2) Delete all unused status codes from the Status Control of each function panel when you are finished development of your instrument driver, for example in this control the status codes for parameters 1, 3-8, and the codes for Error Opening and Writing to File should be deleted.  Those status codes are provided here as a convenience for during driver development.  

(3) Delete these three (3) notes when you are finished with your driver development.   y   
        Instrument Handle                         Source                                   Count                                    Direction                         N       Trigger Link Input Line                  Trigger Link Output Line               Status                           _                                           #       Timer                                    Delay                                             =Immediate 0 Manual 1 Bus 2 External 3 Trigger Link 4 Timer 5      '                             Acceptor 0 Source 1              6Line 1 1 Line 2 2 Line 3 3 Line 4 4 Line 5 5 Line 6 6              6Line 1 1 Line 2 2 Line 3 3 Line 4 4 Line 5 5 Line 6 6    	           ;Choose O (zero) for the count to define an infinite count. ?      @i
=q        ?                 ?      @i
=q        ?                   s    This function setup the third trigger layer called the chan layer. See the 7001 manual page 5-22 for a complete description of the SCPI trigger model

/* function prototype */

ViStatus Ki7001_SetupChanLayer
(ViSession instrumentHandle,
    ViInt16 source,
    ViInt16 count, 
    ViInt16 direction,
    ViInt16 triggerLinkInputLine,
    ViInt16 triggerLinkOutputLine);         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    
    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFC0101  ID Query not supported - VI_WARN_NSUP_ID_QUERY   
3FFC0102  Reset not supported - VI_WARN_NSUP_RESET      
3FFC0103  Self Test not supported - VI_WARN_NSUP_SELF_TEST  
3FFC0104  Error Query not supported - VI_WARN_NSUP_ERROR_QUERY
3FFC0105  Revision Query not supported - VI_WARN_NSUP_REV_QUERY  
3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0001  Parameter 1 out of range. (String not range checked)
BFFC0002  Parameter 2 (ID Query) out of range.
BFFC0003  Parameter 3 (Reset Device) out of range.
BFFC0004  Parameter 4 out of range.
BFFC0005  Parameter 5 out of range.
BFFC0006  Parameter 6 out of range.
BFFC0007  Parameter 7 out of range.
BFFC0008  Parameter 8 out of range.
BFFC0011  Instrument returned invalid response to ID Query

BFFC0800  Error Opening File      VI_ERROR_INSTR_FILE_OPEN
BFFC0801  Error Writing to File   VI_ERROR_INSTR_FILE_WRITE
BFFC0803  Invalid Response VI_ERROR_INSTR_INTERPRETING_RESPONSE

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.

Notes:

(1) Parameter Error Codes for parameters 1 through 8 are defined in the vpptype.h header file the range is BFFC0001 - BFFC0008; for parameter errors greater than 8, and other instrument specific error codes, use an error code in the range of BFFC0900 to BFFC0FFF.  This is equivalent to using (VI_INSTR_ERROR_OFFSET + n); where n represents each instrument specific error number.  Valid ranges for n are 0 to 6FF.  (All values are given in Hexadecimal Notation)

(2) Delete all unused status codes from the Status Control of each function panel when you are finished development of your instrument driver, for example in this control the status codes for parameters 1, 3-8, and the codes for Error Opening and Writing to File should be deleted.  Those status codes are provided here as a convenience for during driver development.  

(3) Delete these three (3) notes when you are finished with your driver development.     	        Instrument Handle                        Source                                  Count                                   Direction                                 Timer                                    Delay                             K       Trigger Link Input Line                  Trigger Link Output Line               Status                           ^                                                           =Immediate 0 Manual 1 Bus 2 External 3 Trigger Link 4 Timer 5      '                         Acceptor 0 Source 1 ?      @i
=q        ?                 ?      @i
=q        ?                              6Line 1 1 Line 2 2 Line 3 3 Line 4 4 Line 5 5 Line 6 6              6Line 1 1 Line 2 2 Line 3 3 Line 4 4 Line 5 5 Line 6 6    	           Choose O (zero) for the count to define an infinite count.
Choose -1 (minus one) for the count to define a count based on the chan list.   "    This function enables you to bypass a specific layer in the trigger model. This give the capability to move on the next level without waiting the trigger event.

/* Function prototype */

ViStatus Ki7001_Bypass(
    ViSession instrumentHandle,  
    ViInt16 Layer, 
    int bypassDelay);
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    
    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFC0101  ID Query not supported - VI_WARN_NSUP_ID_QUERY   
3FFC0102  Reset not supported - VI_WARN_NSUP_RESET      
3FFC0103  Self Test not supported - VI_WARN_NSUP_SELF_TEST  
3FFC0104  Error Query not supported - VI_WARN_NSUP_ERROR_QUERY
3FFC0105  Revision Query not supported - VI_WARN_NSUP_REV_QUERY  
3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0001  Parameter 1 out of range. (String not range checked)
BFFC0002  Parameter 2 (ID Query) out of range.
BFFC0003  Parameter 3 (Reset Device) out of range.
BFFC0004  Parameter 4 out of range.
BFFC0005  Parameter 5 out of range.
BFFC0006  Parameter 6 out of range.
BFFC0007  Parameter 7 out of range.
BFFC0008  Parameter 8 out of range.
BFFC0011  Instrument returned invalid response to ID Query

BFFC0800  Error Opening File      VI_ERROR_INSTR_FILE_OPEN
BFFC0801  Error Writing to File   VI_ERROR_INSTR_FILE_WRITE
BFFC0803  Invalid Response VI_ERROR_INSTR_INTERPRETING_RESPONSE

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.

Notes:

(1) Parameter Error Codes for parameters 1 through 8 are defined in the vpptype.h header file the range is BFFC0001 - BFFC0008; for parameter errors greater than 8, and other instrument specific error codes, use an error code in the range of BFFC0900 to BFFC0FFF.  This is equivalent to using (VI_INSTR_ERROR_OFFSET + n); where n represents each instrument specific error number.  Valid ranges for n are 0 to 6FF.  (All values are given in Hexadecimal Notation)

(2) Delete all unused status codes from the Status Control of each function panel when you are finished development of your instrument driver, for example in this control the status codes for parameters 1, 3-8, and the codes for Error Opening and Writing to File should be deleted.  Those status codes are provided here as a convenience for during driver development.  

(3) Delete these three (3) notes when you are finished with your driver development.     	        Instrument Handle                U       Status                           0          Bypass Delay                             Layer                                  	           On 1 Off 0               Arm 0 Scan 1 Chan 2   	    This function takes the instrument ou of the idle state so it will enter the first trigger layer. In fact this function initiate the instrument operations.

/* Function prototype */

ViStatus Ki7001_Start(
    ViSession instrumentHandle,
    int continuousInit);
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    
    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFC0101  ID Query not supported - VI_WARN_NSUP_ID_QUERY   
3FFC0102  Reset not supported - VI_WARN_NSUP_RESET      
3FFC0103  Self Test not supported - VI_WARN_NSUP_SELF_TEST  
3FFC0104  Error Query not supported - VI_WARN_NSUP_ERROR_QUERY
3FFC0105  Revision Query not supported - VI_WARN_NSUP_REV_QUERY  
3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0001  Parameter 1 out of range. (String not range checked)
BFFC0002  Parameter 2 (ID Query) out of range.
BFFC0003  Parameter 3 (Reset Device) out of range.
BFFC0004  Parameter 4 out of range.
BFFC0005  Parameter 5 out of range.
BFFC0006  Parameter 6 out of range.
BFFC0007  Parameter 7 out of range.
BFFC0008  Parameter 8 out of range.
BFFC0011  Instrument returned invalid response to ID Query

BFFC0800  Error Opening File      VI_ERROR_INSTR_FILE_OPEN
BFFC0801  Error Writing to File   VI_ERROR_INSTR_FILE_WRITE
BFFC0803  Invalid Response VI_ERROR_INSTR_INTERPRETING_RESPONSE

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.

Notes:

(1) Parameter Error Codes for parameters 1 through 8 are defined in the vpptype.h header file the range is BFFC0001 - BFFC0008; for parameter errors greater than 8, and other instrument specific error codes, use an error code in the range of BFFC0900 to BFFC0FFF.  This is equivalent to using (VI_INSTR_ERROR_OFFSET + n); where n represents each instrument specific error number.  Valid ranges for n are 0 to 6FF.  (All values are given in Hexadecimal Notation)

(2) Delete all unused status codes from the Status Control of each function panel when you are finished development of your instrument driver, for example in this control the status codes for parameters 1, 3-8, and the codes for Error Opening and Writing to File should be deleted.  Those status codes are provided here as a convenience for during driver development.  

(3) Delete these three (3) notes when you are finished with your driver development.   ; $         Instrument Handle                 $      Status                           $          Continuous Init                        	           On 1 Off 0        This function cancel any pending operations on the instrument. It stops the trigger model.

/* Function prototype */

ViStatus Ki7001_Stop (ViSession instrumentHandle);
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    
    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFC0101  ID Query not supported - VI_WARN_NSUP_ID_QUERY   
3FFC0102  Reset not supported - VI_WARN_NSUP_RESET      
3FFC0103  Self Test not supported - VI_WARN_NSUP_SELF_TEST  
3FFC0104  Error Query not supported - VI_WARN_NSUP_ERROR_QUERY
3FFC0105  Revision Query not supported - VI_WARN_NSUP_REV_QUERY  
3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0001  Parameter 1 out of range. (String not range checked)
BFFC0002  Parameter 2 (ID Query) out of range.
BFFC0003  Parameter 3 (Reset Device) out of range.
BFFC0004  Parameter 4 out of range.
BFFC0005  Parameter 5 out of range.
BFFC0006  Parameter 6 out of range.
BFFC0007  Parameter 7 out of range.
BFFC0008  Parameter 8 out of range.
BFFC0011  Instrument returned invalid response to ID Query

BFFC0800  Error Opening File      VI_ERROR_INSTR_FILE_OPEN
BFFC0801  Error Writing to File   VI_ERROR_INSTR_FILE_WRITE
BFFC0803  Invalid Response VI_ERROR_INSTR_INTERPRETING_RESPONSE

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.

Notes:

(1) Parameter Error Codes for parameters 1 through 8 are defined in the vpptype.h header file the range is BFFC0001 - BFFC0008; for parameter errors greater than 8, and other instrument specific error codes, use an error code in the range of BFFC0900 to BFFC0FFF.  This is equivalent to using (VI_INSTR_ERROR_OFFSET + n); where n represents each instrument specific error number.  Valid ranges for n are 0 to 6FF.  (All values are given in Hexadecimal Notation)

(2) Delete all unused status codes from the Status Control of each function panel when you are finished development of your instrument driver, for example in this control the status codes for parameters 1, 3-8, and the codes for Error Opening and Writing to File should be deleted.  Those status codes are provided here as a convenience for during driver development.  

(3) Delete these three (3) notes when you are finished with your driver development.   
 -         Instrument Handle                 -      Status                                 	              This function resets the instrument to a known state and sends initialization commands to the instrument that set any necessary programmatic variables such as Headers Off, Short Command form, and Data Transfer Binary to the state necessary for the operation of the instrument driver.

/**** DELETE THIS NOTE AND THE STATUS CODE IF SUPPORTED *****/
Notes:

(1) If this instrument does not support a Reset, this function should return the Warning Code 0x3FFC0102 - VI_WARN_NSUP_RESET
        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFC0102  Reset not supported - VI_WARN_NSUP_RESET      
3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    +      Status                            +         Instrument Handle                  	              %    This function runs the instrument's self test routine and returns the test result(s).

/**** DELETE THIS NOTE AND THE STATUS CODE IF SUPPORTED *****/
Notes:

(1) If this instrument does not support a Self-Test, this function should return the Warning Code 0x3FFC0103 - VI_WARN_NSUP_SELF_TEST         This control contains the value returned from the instrument self test.  Zero means success.  For any other code, see the device's operator's manual.
         This control contains the string returned from the self test. See the device's operation manual for an explanation of the string's contents.

Notes:

(1) The array must contain at least 256 elements ViChar[256].        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFC0103  Self Test not supported - VI_WARN_NSUP_SELF_TEST  
3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    "         Self Test Result                   "   ,    Self-Test Message                !p s       Status                           %R s         Instrument Handle                  	           	            	                  This function reads an error code from the instrument's error queue.

/**** DELETE THIS NOTE AND THE STATUS CODE IF SUPPORTED *****/
Notes:

(1) If this instrument does not support an Error Query, this function should return the Warning Code 0x3FFC0104 - VI_WARN_NSUP_ERROR_QUERY     N    This control returns the error code read from the instrument's error queue.
         This control returns the error message string read from the instrument's error message queue.

Notes:

(1) The array must contain at least 256 elements ViChar[256].        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFC0104  Error Query not supported - VI_WARN_NSUP_ERROR_QUERY
3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None   (          Error Code                       (d    ,    Error Message                    ) f       Status                           , f         Instrument Handle                  	            	            	                   This function takes the Status Code returned by the instrument driver functions, interprets it and returns it as a user readable string.      t    This control accepts the Status Code returned from the instrument driver functions.

Default Value:
0 - VI_SUCCESS         This control returns the interpreted Status Code as a user readable message string.

Notes:

(1) The array must contain at least 256 elements ViChar[256].        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

3FFF0085  VI_WARN_UNKNOWN_STATUS

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  VI_NULL   /$           Status Code                      /         Message                          0D f      Status                           4 r         Instrument Handle                  0    	            	           VI_NULL   Z    This function returns the revision numbers of the instrument driver and instrument firmware, and tells the user with which  instrument firmware this revision of the driver is compatible. 

/**** CHANGE THE REVISION NUMBER AND FIRMWARE REVISION *****/
This instrument driver's Revision Number is "Rev 1.0, 10/96, CVI 3.1" and is compatible with Instrument Firmware Revision "XXX".

/**** DELETE THIS NOTE AND THE STATUS CODE IF SUPPORTED *****/
Notes:

(1) If this instrument does not support a Firmware Revision Query, this function should return the Warning Code 0x3FFC0105 - VI_WARN_NSUP_REV_QUERY.         This control returns the Instrument Driver Software Revision.

Notes:

(1) The array must contain at least 256 elements ViChar[256].         This control returns the Instrument Firmware Revision.

Notes:

(1) The array must contain at least 256 elements ViChar[256].        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFC0105  Revision Query not supported - VI_WARN_NSUP_REV_QUERY  
3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None   8  5       Instrument Driver Revision       8 -       Firmware Revision                9  c      Status                           = c 	        Instrument Handle                  	            	            	                   This function performs the following operations:
viClose (instrSession) and viClose (rmSession).

Notes:

(1) The instrument must be reinitialized to use it again.        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None   ?O $      Status                           B $         Instrument Handle                  	                       3      .    init                                     5   B      .    FrontPanel                               Ck  O      P.    TTLOutput                                PU  ^p     z.    DefineScannerCard                        `~  l      V.    QueryScannerCard                         m  {@      Y.    SetPoles                                 |g        V.    QueryPoles                                       Y.    SetSettlingTime                                  Y.    QuerySettlingTime                          S      S.    EnableBBM                                  9      Q.    QueryBBM                                   r      T.    EnableSingleChan                         ;  [      T.    QuerySingleChan                            q      Y.    EnableCardPairing                        :  Y      T.    QueryCardPairing                           F      a.    TTLInput                                 f 
U      U.    SaveSetup                                4      U.    RecallSetup                              ':      .    POSetup                                 ( 8      .    Close                                   9} I      .    Open                                    J= V+      X.    OpenAll                                 V f      .    ScanList                                gz tR      V.    StoreRelayPattern                       u T      Y.    RecallRelayPattern                             .    WriteRegister                            j     p.    ReadRegister                            M      K.    ClearRegisters                           V     K.    SetupSRQ                                &       .    SetupArmLayer                             
    K.    SetupScanLayer                          ߞ x 
    K.    SetupChanLayer                                 S.    Bypass                                  * 
      X.    Start                                   W i      a.    Stop                                     L      ].    reset                                    %      .    selfTest                                & -      .    errorQuery                              . 4      .    errorMessage                            5 =      .    revisionQuery                           > C      V.    close                                                                      DInitialize                          sMiscellaneous Functions              DControl Front Panel Display          DControl TTL Ouputs                   DScanner Card                         DQuery Scanner Card                   DSet Number of poles                  DQuery Number of poles                DCard Settling Time                   DQuery Card Settling Time             DBreak Before Make Switch             DQuery Break Before Make Switch       DSingle Channel Mode                  DQuery Single Channel Mode            DCard Pairing                         DQuery Card Pairing                   DRead TTL Inputs                      DSave Setup                           DRecall Setup                         DDefine Power On Default Setup       Route                                DClose                                DOpen                                 DOpen All                             DDefine Scan List                     DStore Relay Pattern                  DRecall Relay Pattern                Instrument Registers                 DWrite to a Register                  DRead from a Register                 DClear Registers                      DDefine Conditions for SRQ           Triggers                             DSetup Arm Layer                      DSetup Scan Layer                     DSetup Channel Layer                  DBypass a Layer                       DInitiate trigger model               DHalt trigger model                  Utility Functions                    DReset                                DSelf-Test                            DError-Query                          DError Message                        DRevision Query                       DClose                           